/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongConsumer;

public final class ProgressReporter {
    private final LongConsumer progressListener;
    private final Lock listenerLock;
    private final ProgressReporter parent;
    private static final AtomicLongFieldUpdater<ProgressReporter> PROGRESS_ATOMIC_UPDATER = AtomicLongFieldUpdater.newUpdater(ProgressReporter.class, "progress");
    private volatile long progress;

    private ProgressReporter(LongConsumer progressListener) {
        this.progressListener = Objects.requireNonNull(progressListener, "'progressListener' must not be null");
        this.listenerLock = new ReentrantLock();
        this.parent = null;
    }

    private ProgressReporter(ProgressReporter parent) {
        this.parent = Objects.requireNonNull(parent, "'parent' must not be null");
        this.progressListener = null;
        this.listenerLock = null;
    }

    public static ProgressReporter withProgressListener(LongConsumer progressListener) {
        return new ProgressReporter(progressListener);
    }

    public ProgressReporter createChild() {
        return new ProgressReporter(this);
    }

    public void reset() {
        try {
            if (this.listenerLock != null) {
                this.listenerLock.lock();
            }
            long accumulated = PROGRESS_ATOMIC_UPDATER.getAndSet(this, 0L);
            if (this.parent != null) {
                this.parent.reportProgress(-1L * accumulated);
            }
            if (this.progressListener != null) {
                this.progressListener.accept(0L);
            }
        }
        finally {
            if (this.listenerLock != null) {
                this.listenerLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportProgress(long progress) {
        try {
            if (this.listenerLock != null) {
                this.listenerLock.lock();
            }
            long totalProgress = PROGRESS_ATOMIC_UPDATER.addAndGet(this, progress);
            if (this.parent != null) {
                this.parent.reportProgress(progress);
            }
            if (this.progressListener != null) {
                this.progressListener.accept(totalProgress);
            }
        }
        finally {
            if (this.listenerLock != null) {
                this.listenerLock.unlock();
            }
        }
    }
}

