/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpHeaders;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.utils.AuthUtils;
import io.clientcore.core.utils.AuthenticateChallenge;
import io.clientcore.core.utils.ChallengeHandler;
import io.clientcore.core.utils.CoreUtils;
import java.net.URI;
import java.security.SecureRandom;
import java.util.AbstractMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DigestChallengeHandler
implements ChallengeHandler {
    private final String username;
    private final String password;
    private static final String REALM = "realm";
    private static final String NONCE = "nonce";
    private static final String QOP = "qop";
    private static final String AUTH = "auth";
    private static final String AUTH_INT = "auth-int";
    private static final String USERHASH = "userhash";
    private static final String OPAQUE = "opaque";
    private final SecureRandom nonceGenerator = new SecureRandom();
    private final Map<String, AtomicInteger> nonceTracker = new ConcurrentHashMap<String, AtomicInteger>();
    private static final String SHA_512_256_SESS = "SHA-512-256-SESS";
    private static final String SHA_256 = "SHA-256";
    private static final String SHA_256_SESS = "SHA-256-SESS";
    private static final String MD5_SESS = "MD5-SESS";
    private static final String[] ALGORITHM_PREFERENCE_ORDER = new String[]{"SHA-512-256", "SHA-512-256-SESS", "SHA-256", "SHA-256-SESS", "MD5", "MD5-SESS"};

    public DigestChallengeHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public void handleChallenge(HttpRequest request, Response<BinaryData> response, boolean isProxy) {
        if (!this.canHandle(response, isProxy)) {
            return;
        }
        Map<String, List<Map<String, String>>> challengesByType = AuthUtils.partitionByChallengeType(response.getHeaders());
        for (String algorithm : ALGORITHM_PREFERENCE_ORDER) {
            Map challengeParams;
            Function<byte[], byte[]> digestFunction;
            List<Map<String, String>> challengeForType = challengesByType.get(algorithm);
            if (CoreUtils.isNullOrEmpty(challengeForType) || (digestFunction = AuthUtils.getDigestFunction(algorithm)) == null || (challengeParams = (Map)challengeForType.stream().filter(params -> !CoreUtils.isNullOrEmpty(params)).findFirst().orElse(null)) == null) continue;
            String digestAuthHeader = this.generateDigestAuthHeader(request.getHttpMethod().name(), request.getUri().toString(), algorithm, challengeParams, digestFunction, response.getValue());
            HttpHeaderName headerName = isProxy ? HttpHeaderName.PROXY_AUTHORIZATION : HttpHeaderName.AUTHORIZATION;
            request.getHeaders().set(headerName, digestAuthHeader);
            return;
        }
    }

    @Override
    public boolean canHandle(Response<BinaryData> response, boolean isProxy) {
        HttpHeaders responseHeaders = response.getHeaders();
        if (responseHeaders == null) {
            return false;
        }
        HttpHeaderName authHeaderName = isProxy ? HttpHeaderName.PROXY_AUTHENTICATE : HttpHeaderName.WWW_AUTHENTICATE;
        List<String> authenticateHeaders = responseHeaders.getValues(authHeaderName);
        if (CoreUtils.isNullOrEmpty(authenticateHeaders)) {
            return false;
        }
        for (String authenticateHeader : authenticateHeaders) {
            for (AuthenticateChallenge challenge : AuthUtils.parseAuthenticateHeader(authenticateHeader)) {
                if (!DigestChallengeHandler.canHandle(challenge)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Map.Entry<String, AuthenticateChallenge> handleChallenge(String method, URI uri, List<AuthenticateChallenge> challenges) {
        Objects.requireNonNull(challenges, "Cannot use a null 'challenges' to handle challenges.");
        if (!this.canHandle(challenges)) {
            return null;
        }
        Map<String, List<AuthenticateChallenge>> challengesByType = challenges.stream().collect(Collectors.groupingBy(challenge -> {
            String algorithmHeader = challenge.getParameters().get("algorithm");
            return CoreUtils.isNullOrEmpty(algorithmHeader) ? "MD5" : algorithmHeader.toUpperCase(Locale.ROOT);
        }));
        for (String algorithm : ALGORITHM_PREFERENCE_ORDER) {
            AuthenticateChallenge authenticateChallenge;
            Function<byte[], byte[]> digestFunction;
            List<AuthenticateChallenge> challengeForType = challengesByType.get(algorithm);
            if (CoreUtils.isNullOrEmpty(challengeForType) || (digestFunction = AuthUtils.getDigestFunction(algorithm)) == null || (authenticateChallenge = (AuthenticateChallenge)challengeForType.stream().filter(challenge -> !CoreUtils.isNullOrEmpty(challenge.getParameters())).findFirst().orElse(null)) == null) continue;
            String path = uri.getPath();
            if (path == null) {
                path = "/";
            }
            return new AbstractMap.SimpleImmutableEntry<String, AuthenticateChallenge>(this.generateDigestAuthHeader(method, path, algorithm, authenticateChallenge.getParameters(), digestFunction, BinaryData.empty()), authenticateChallenge);
        }
        return null;
    }

    @Override
    public boolean canHandle(List<AuthenticateChallenge> challenges) {
        Objects.requireNonNull(challenges, "Cannot use a null 'challenges' to determine if it can be handled.");
        for (AuthenticateChallenge challenge : challenges) {
            if (!DigestChallengeHandler.canHandle(challenge)) continue;
            return true;
        }
        return false;
    }

    private static boolean canHandle(AuthenticateChallenge challenge) {
        return challenge != null && "Digest".equalsIgnoreCase(challenge.getScheme());
    }

    String generateCnonce() {
        byte[] nonce = new byte[16];
        this.nonceGenerator.nextBytes(nonce);
        return AuthUtils.bytesToHexString(nonce);
    }

    private String generateDigestAuthHeader(String method, String uri, String algorithm, Map<String, String> challengeParams, Function<byte[], byte[]> digestFunction, BinaryData body) {
        String nonce = challengeParams.get(NONCE);
        String realm = challengeParams.get(REALM);
        String qop = challengeParams.get(QOP);
        String opaque = challengeParams.get(OPAQUE);
        boolean hashUsername = Boolean.parseBoolean(challengeParams.get(USERHASH));
        int nc = 0;
        String clientNonce = null;
        if (AUTH.equals(qop) || AUTH_INT.equals(qop)) {
            clientNonce = this.generateCnonce();
            nc = this.getOrUpdateNonceCount(nonce);
        } else if (algorithm.endsWith("-SESS")) {
            clientNonce = this.generateCnonce();
        }
        String ha1 = algorithm.endsWith("-SESS") ? AuthUtils.calculateHa1Sess(digestFunction, this.username, realm, this.password, nonce, clientNonce) : AuthUtils.calculateHa1NoSess(digestFunction, this.username, realm, this.password);
        String ha2 = AUTH_INT.equals(qop) ? AuthUtils.calculateHa2AuthIntQop(digestFunction, method, uri, body.toBytes()) : AuthUtils.calculateHa2AuthQopOrEmpty(digestFunction, method, uri);
        String response = AUTH.equals(qop) || AUTH_INT.equals(qop) ? AuthUtils.calculateResponseKnownQop(digestFunction, ha1, nonce, nc, clientNonce, qop, ha2) : AuthUtils.calculateResponseUnknownQop(digestFunction, ha1, nonce, ha2);
        String headerUsername = hashUsername ? AuthUtils.calculateUserhash(digestFunction, this.username, realm) : this.username;
        return AuthUtils.buildAuthorizationHeader(headerUsername, realm, uri, algorithm, nonce, nc, clientNonce, qop, response, opaque, hashUsername);
    }

    private int getOrUpdateNonceCount(String nonce) {
        return this.nonceTracker.compute(nonce, (ignored, value) -> {
            if (value == null) {
                return new AtomicInteger(1);
            }
            value.incrementAndGet();
            return value;
        }).get();
    }
}

