/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.xml.implementation.aalto.out;

import io.clientcore.core.serialization.xml.implementation.aalto.impl.CommonConfig;
import io.clientcore.core.serialization.xml.implementation.aalto.out.CharXmlWriter;
import io.clientcore.core.serialization.xml.implementation.aalto.out.WNameTable;
import java.util.HashMap;

public final class WriterConfig
extends CommonConfig {
    static final int F_NS_REPAIRING = 1;
    static final int F_NS_AWARE = 32;
    static final int F_AUTO_EMPTY_ELEMS = 64;
    static final int DEFAULT_FLAGS = 32;
    private static final HashMap<String, Integer> sProperties = new HashMap();
    private final EncodingContext _encodingContext;

    private WriterConfig(int flags, int flagMods, EncodingContext encCtxt) {
        super(flags, flagMods);
        this._encodingContext = encCtxt;
        this._flags = flags;
        this._flagMods = flagMods;
    }

    public WriterConfig() {
        this(32, 0, new EncodingContext());
    }

    public WriterConfig createNonShared() {
        return new WriterConfig(this._flags, this._flagMods, this._encodingContext);
    }

    @Override
    public Object getProperty(String name, boolean isMandatory) {
        Integer I = sProperties.get(name);
        if (I == null) {
            if (sProperties.containsKey(name)) {
                return null;
            }
            return super.getProperty(name, isMandatory);
        }
        int f = I;
        if (f >= 0) {
            return this.hasFlag(f);
        }
        return null;
    }

    @Override
    public boolean setProperty(String name, Object value) {
        Integer I = sProperties.get(name);
        if (I == null) {
            if (sProperties.containsKey(name)) {
                return false;
            }
            return super.setProperty(name, value);
        }
        int f = I;
        if (f >= 0) {
            boolean state = (Boolean)value;
            if (f == 32 && !state) {
                return false;
            }
            this.setFlag(f, state);
            return true;
        }
        return false;
    }

    @Override
    public boolean isPropertySupported(String propName) {
        return sProperties.containsKey(propName) || super.isPropertySupported(propName);
    }

    public WNameTable getCharSymbols(CharXmlWriter f) {
        return this._encodingContext.getCharSymbols(f);
    }

    static {
        sProperties.put("javax.xml.stream.isRepairingNamespaces", 1);
        sProperties.put("javax.xml.stream.isNamespaceAware", 32);
        sProperties.put("javax.xml.stream.reporter", null);
        sProperties.put("io.clientcore.core.serialization.xml.implementation.stax2.automaticEmptyElements", 64);
    }

    static final class EncodingContext {
        WNameTable mCharTable;

        EncodingContext() {
        }

        public synchronized WNameTable getCharSymbols(CharXmlWriter f) {
            if (this.mCharTable == null) {
                this.mCharTable = new WNameTable(64);
            }
            return this.mCharTable.createChild(f);
        }
    }
}

