/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.xml.implementation.aalto.out;

import io.clientcore.core.serialization.xml.implementation.aalto.util.XmlCharTypes;
import io.clientcore.core.serialization.xml.implementation.aalto.util.XmlChars;

public final class OutputCharTypes
extends XmlCharTypes {
    static final int MAIN_TABLE_SIZE = 2048;
    public static final int CT_OUTPUT_MUST_QUOTE = 4;
    public static final int CT_OUTPUT_NAME_NONFIRST_MB2 = 5;
    public static final int CT_OUTPUT_NAME_ANY_MB2 = 6;
    private static XmlCharTypes sLatin1CharTypes = null;
    private static final XmlCharTypes sUtf8CharTypes = new XmlCharTypes(2048);

    public static XmlCharTypes getLatin1CharTypes() {
        if (sLatin1CharTypes == null) {
            sLatin1CharTypes = new XmlCharTypes(2048);
            OutputCharTypes.fillInLatin1Chars(OutputCharTypes.sLatin1CharTypes.TEXT_CHARS, OutputCharTypes.sLatin1CharTypes.ATTR_CHARS, OutputCharTypes.sLatin1CharTypes.NAME_CHARS, OutputCharTypes.sLatin1CharTypes.DTD_CHARS, OutputCharTypes.sLatin1CharTypes.OTHER_CHARS);
            OutputCharTypes.modifyForLatin1(OutputCharTypes.sLatin1CharTypes.TEXT_CHARS);
            OutputCharTypes.modifyForLatin1(OutputCharTypes.sLatin1CharTypes.ATTR_CHARS);
            OutputCharTypes.modifyForLatin1(OutputCharTypes.sLatin1CharTypes.DTD_CHARS);
            OutputCharTypes.modifyForLatin1(OutputCharTypes.sLatin1CharTypes.OTHER_CHARS);
            OutputCharTypes.modifyForAttrWrite(OutputCharTypes.sLatin1CharTypes.ATTR_CHARS);
        }
        return sLatin1CharTypes;
    }

    private static void modifyForLatin1(int[] charTable) {
        for (int i = 127; i <= 159; ++i) {
            charTable[i] = 4;
        }
        OutputCharTypes.requireQuotingAfter(charTable);
    }

    private static void modifyForUtf8(int[] charTable) {
        int len = charTable.length;
        for (int i = 128; i < len; ++i) {
            if (charTable[i] != 0) continue;
            charTable[i] = 5;
        }
    }

    private static void modifyUtf8Names(int[] charTable) {
        int len = charTable.length;
        for (int i = 128; i < len; ++i) {
            charTable[i] = XmlChars.is10NameStartChar(i) ? 6 : (XmlChars.is10NameChar(i) ? 5 : 0);
        }
    }

    private static void modifyForAttrWrite(int[] charTable) {
        charTable[9] = 4;
    }

    private static void requireQuotingAfter(int[] charTable) {
        int len = charTable.length;
        for (int i = 256; i < len; ++i) {
            if (charTable[i] != 0) continue;
            charTable[i] = 4;
        }
    }

    static {
        OutputCharTypes.fillInLatin1Chars(OutputCharTypes.sUtf8CharTypes.TEXT_CHARS, OutputCharTypes.sUtf8CharTypes.ATTR_CHARS, OutputCharTypes.sUtf8CharTypes.NAME_CHARS, OutputCharTypes.sUtf8CharTypes.DTD_CHARS, OutputCharTypes.sUtf8CharTypes.OTHER_CHARS);
        OutputCharTypes.modifyForUtf8(OutputCharTypes.sUtf8CharTypes.TEXT_CHARS);
        OutputCharTypes.modifyForUtf8(OutputCharTypes.sUtf8CharTypes.ATTR_CHARS);
        OutputCharTypes.modifyForUtf8(OutputCharTypes.sUtf8CharTypes.DTD_CHARS);
        OutputCharTypes.modifyForUtf8(OutputCharTypes.sUtf8CharTypes.OTHER_CHARS);
        OutputCharTypes.modifyUtf8Names(OutputCharTypes.sUtf8CharTypes.NAME_CHARS);
        OutputCharTypes.modifyForAttrWrite(OutputCharTypes.sUtf8CharTypes.ATTR_CHARS);
    }
}

