/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.json.models;

import io.clientcore.core.implementation.utils.Option;
import io.clientcore.core.serialization.json.JsonReader;
import io.clientcore.core.serialization.json.JsonSerializable;
import io.clientcore.core.serialization.json.JsonSerializer;
import io.clientcore.core.serialization.json.JsonWriter;
import io.clientcore.core.serialization.json.models.JsonPatchOperation;
import io.clientcore.core.serialization.json.models.JsonPatchOperationKind;
import io.clientcore.core.utils.CoreUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class JsonPatchDocument
implements JsonSerializable<JsonPatchDocument> {
    private final JsonSerializer serializer;
    private final List<JsonPatchOperation> operations = new ArrayList<JsonPatchOperation>();

    public JsonPatchDocument() {
        this(null);
    }

    public JsonPatchDocument(JsonSerializer serializer) {
        this.serializer = Objects.requireNonNull(serializer, "'serializer' cannot be null.");
    }

    List<JsonPatchOperation> getOperations() {
        return new ArrayList<JsonPatchOperation>(this.operations);
    }

    public JsonPatchDocument appendAdd(String path, Object value) throws IOException {
        return this.appendAddInternal(path, this.serializeValue(value));
    }

    public JsonPatchDocument appendAddRaw(String path, String rawJson) {
        return this.appendAddInternal(path, Option.of(rawJson));
    }

    private JsonPatchDocument appendAddInternal(String path, Option<String> rawJsonOption) {
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.ADD, null, path, rawJsonOption);
    }

    public JsonPatchDocument appendReplace(String path, Object value) throws IOException {
        return this.appendReplaceInternal(path, this.serializeValue(value));
    }

    public JsonPatchDocument appendReplaceRaw(String path, String rawJson) {
        return this.appendReplaceInternal(path, Option.of(rawJson));
    }

    private JsonPatchDocument appendReplaceInternal(String path, Option<String> rawJsonOption) {
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.REPLACE, null, path, rawJsonOption);
    }

    public JsonPatchDocument appendCopy(String from, String path) {
        Objects.requireNonNull(from, "'from' cannot be null.");
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.COPY, from, path, Option.uninitialized());
    }

    public JsonPatchDocument appendMove(String from, String path) {
        Objects.requireNonNull(from, "'from' cannot be null.");
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.MOVE, from, path, Option.uninitialized());
    }

    public JsonPatchDocument appendRemove(String path) {
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.REMOVE, null, path, Option.uninitialized());
    }

    public JsonPatchDocument appendTest(String path, Object value) throws IOException {
        return this.appendTestInternal(path, this.serializeValue(value));
    }

    public JsonPatchDocument appendTestRaw(String path, String rawJson) {
        return this.appendTestInternal(path, Option.of(rawJson));
    }

    private JsonPatchDocument appendTestInternal(String path, Option<String> rawJsonOption) {
        Objects.requireNonNull(path, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.TEST, null, path, rawJsonOption);
    }

    private Option<String> serializeValue(Object value) throws IOException {
        if (value == null) {
            return Option.empty();
        }
        byte[] bytes = this.serializer.serializeToBytes(value);
        return Option.of(new String(bytes, StandardCharsets.UTF_8));
    }

    private JsonPatchDocument appendOperation(JsonPatchOperationKind operationKind, String from, String path, Option<String> optionalValue) {
        this.operations.add(new JsonPatchOperation(operationKind, from, path, optionalValue));
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < this.operations.size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            this.operations.get(i).buildString(builder);
        }
        return builder.append("]").toString();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return CoreUtils.isNullOrEmpty(this.operations) ? jsonWriter : jsonWriter.writeArray(this.operations, JsonWriter::writeJson);
    }

    public static JsonPatchDocument fromJson(JsonReader jsonReader) throws IOException {
        List<JsonPatchOperation> operations = jsonReader.readArray(JsonPatchOperation::fromJson);
        JsonPatchDocument document = new JsonPatchDocument();
        if (operations != null) {
            document.operations.addAll(operations);
        }
        return document;
    }
}

