/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.json.implementation.jackson.core.json;

import io.clientcore.core.serialization.json.implementation.jackson.core.Base64Variants;
import io.clientcore.core.serialization.json.implementation.jackson.core.JsonGenerationException;
import io.clientcore.core.serialization.json.implementation.jackson.core.JsonGenerator;
import io.clientcore.core.serialization.json.implementation.jackson.core.JsonStreamContext;
import io.clientcore.core.serialization.json.implementation.jackson.core.io.CharTypes;
import io.clientcore.core.serialization.json.implementation.jackson.core.io.IOContext;
import io.clientcore.core.serialization.json.implementation.jackson.core.io.NumberOutput;
import io.clientcore.core.serialization.json.implementation.jackson.core.json.JsonWriteContext;
import java.io.IOException;
import java.io.Writer;

public class WriterBasedJsonGenerator
extends JsonGenerator {
    protected static final char[] HEX_CHARS = CharTypes.copyHexChars();
    protected static final String WRITE_BINARY = "write a binary value";
    protected static final String WRITE_BOOLEAN = "write a boolean value";
    protected static final String WRITE_NULL = "write a null";
    protected static final String WRITE_NUMBER = "write a number";
    protected static final String WRITE_STRING = "write a string";
    protected final IOContext _ioContext;
    protected final Writer _writer;
    protected int _outputTail;
    protected int _outputEnd;
    protected char[] _outputBuffer;
    protected int _outputHead;
    protected char[] _entityBuffer;
    protected JsonWriteContext _writeContext;

    public WriterBasedJsonGenerator(IOContext ctxt, int features, Writer w) {
        super(features);
        this._ioContext = ctxt;
        this._writer = w;
        this._outputBuffer = ctxt.allocConcatBuffer();
        this._outputEnd = this._outputBuffer.length;
        this._writeContext = JsonWriteContext.createRootContext();
    }

    @Override
    public void writeFieldName(String name) throws IOException {
        int status = this._writeContext.writeFieldName(name);
        if (status == 4) {
            throw new JsonGenerationException("Can not write a field name, expecting a value", this);
        }
        this._writeFieldName(name, status == 1);
    }

    protected final void _writeFieldName(String name, boolean commaBefore) throws IOException {
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (commaBefore) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(name);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 91;
    }

    @Override
    public void writeEndArray() throws IOException {
        if (!this._writeContext.inArray()) {
            throw new JsonGenerationException("Current context not Array but " + this._writeContext.typeDesc(), this);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 93;
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    @Override
    public void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 123;
    }

    @Override
    public void writeEndObject() throws IOException {
        if (!this._writeContext.inObject()) {
            throw new JsonGenerationException("Current context not Object but " + this._writeContext.typeDesc(), this);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 125;
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    @Override
    public void writeString(String text) throws IOException {
        this._verifyValueWrite(WRITE_STRING);
        if (text == null) {
            this._writeNull();
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(text);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void writeRaw(String text) throws IOException {
        int len = text.length();
        int room = this._outputEnd - this._outputTail;
        if (room == 0) {
            this._flushBuffer();
            room = this._outputEnd - this._outputTail;
        }
        if (room >= len) {
            text.getChars(0, len, this._outputBuffer, this._outputTail);
            this._outputTail += len;
        } else {
            this.writeRawLong(text);
        }
    }

    private void writeRawLong(String text) throws IOException {
        int len;
        int amount;
        int room = this._outputEnd - this._outputTail;
        text.getChars(0, room, this._outputBuffer, this._outputTail);
        this._outputTail += room;
        this._flushBuffer();
        int offset = room;
        for (len = text.length() - room; len > this._outputEnd; len -= amount) {
            amount = this._outputEnd;
            text.getChars(offset, offset + amount, this._outputBuffer, 0);
            this._outputHead = 0;
            this._outputTail = amount;
            this._flushBuffer();
            offset += amount;
        }
        text.getChars(offset, offset + len, this._outputBuffer, 0);
        this._outputHead = 0;
        this._outputTail = len;
    }

    @Override
    public void writeBinary(byte[] data) throws IOException {
        this._verifyValueWrite(WRITE_BINARY);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeBinary(data, 0, data.length);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeNumber(int i) throws IOException {
        this._verifyValueWrite(WRITE_NUMBER);
        if (this._outputTail + 11 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputInt(i, this._outputBuffer, this._outputTail);
    }

    @Override
    public void writeNumber(long l) throws IOException {
        this._verifyValueWrite(WRITE_NUMBER);
        if (this._outputTail + 21 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
    }

    @Override
    public void writeNumber(double d) throws IOException {
        if (this.isQuoteNonNumericNumbersEnabled() && !Double.isFinite(d)) {
            this.writeString(String.valueOf(d));
            return;
        }
        this._verifyValueWrite(WRITE_NUMBER);
        this.writeRaw(String.valueOf(d));
    }

    @Override
    public void writeNumber(float f) throws IOException {
        if (this.isQuoteNonNumericNumbersEnabled() && !Float.isFinite(f)) {
            this.writeString(String.valueOf(f));
            return;
        }
        this._verifyValueWrite(WRITE_NUMBER);
        this.writeRaw(String.valueOf(f));
    }

    private boolean isQuoteNonNumericNumbersEnabled() {
        return this._features != 0;
    }

    @Override
    public void writeBoolean(boolean state) throws IOException {
        this._verifyValueWrite(WRITE_BOOLEAN);
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        int ptr = this._outputTail;
        char[] buf = this._outputBuffer;
        if (state) {
            buf[ptr] = 116;
            buf[++ptr] = 114;
            buf[++ptr] = 117;
            buf[++ptr] = 101;
        } else {
            buf[ptr] = 102;
            buf[++ptr] = 97;
            buf[++ptr] = 108;
            buf[++ptr] = 115;
            buf[++ptr] = 101;
        }
        this._outputTail = ptr + 1;
    }

    @Override
    public void writeNull() throws IOException {
        this._verifyValueWrite(WRITE_NULL);
        this._writeNull();
    }

    @Override
    public void writeRawValue(String text) throws IOException {
        this._verifyValueWrite("write raw value");
        this.writeRaw(text);
    }

    @Override
    public JsonStreamContext getOutputContext() {
        return this._writeContext;
    }

    protected final void _verifyValueWrite(String typeMsg) throws IOException {
        int c;
        int status = this._writeContext.writeValue();
        switch (status) {
            default: {
                return;
            }
            case 1: {
                c = 44;
                break;
            }
            case 2: {
                c = 58;
                break;
            }
            case 3: {
                this.writeRaw(" ");
                return;
            }
            case 5: {
                this._reportCantWriteValueExpectName(typeMsg);
                return;
            }
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c;
    }

    @Override
    public void flush() throws IOException {
        this._flushBuffer();
        if (this._writer != null) {
            this._writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        char[] buf;
        if (this._outputBuffer != null) {
            while (true) {
                JsonStreamContext ctxt;
                if ((ctxt = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!ctxt.inObject()) break;
                this.writeEndObject();
            }
        }
        this._flushBuffer();
        this._outputHead = 0;
        this._outputTail = 0;
        if (this._writer != null) {
            this._writer.flush();
        }
        if ((buf = this._outputBuffer) != null) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(buf);
        }
    }

    private void _writeString(String text) throws IOException {
        int len = text.length();
        if (len > this._outputEnd) {
            this._writeLongString(text);
            return;
        }
        if (this._outputTail + len > this._outputEnd) {
            this._flushBuffer();
        }
        text.getChars(0, len, this._outputBuffer, this._outputTail);
        this._writeString2(len);
    }

    private void _writeString2(int len) throws IOException {
        int end = this._outputTail + len;
        int[] escCodes = CharTypes.get7BitOutputEscapes();
        int escLen = escCodes.length;
        block0: while (this._outputTail < end) {
            char c;
            while ((c = this._outputBuffer[this._outputTail]) >= escLen || escCodes[c] == 0) {
                if (++this._outputTail < end) continue;
                break block0;
            }
            int flushLen = this._outputTail - this._outputHead;
            if (flushLen > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, flushLen);
            }
            char c2 = this._outputBuffer[this._outputTail++];
            this._prependOrWriteCharacterEscape(c2, escCodes[c2]);
        }
    }

    private void _writeLongString(String text) throws IOException {
        int segmentLen;
        this._flushBuffer();
        int textLen = text.length();
        int offset = 0;
        do {
            int max;
            segmentLen = offset + (max = this._outputEnd) > textLen ? textLen - offset : max;
            text.getChars(offset, offset + segmentLen, this._outputBuffer, 0);
            this._writeSegment(segmentLen);
        } while ((offset += segmentLen) < textLen);
    }

    private void _writeSegment(int end) throws IOException {
        int ptr;
        int[] escCodes = CharTypes.get7BitOutputEscapes();
        int escLen = escCodes.length;
        int start = ptr = 0;
        while (ptr < end) {
            char c;
            while (((c = this._outputBuffer[ptr]) >= escLen || escCodes[c] == 0) && ++ptr < end) {
            }
            int flushLen = ptr - start;
            if (flushLen > 0) {
                this._writer.write(this._outputBuffer, start, flushLen);
                if (ptr >= end) break;
            }
            start = this._prependOrWriteCharacterEscape(this._outputBuffer, ++ptr, end, c, escCodes[c]);
        }
    }

    protected final void _writeBinary(byte[] input, int inputPtr, int inputEnd) throws IOException {
        int safeInputEnd = inputEnd - 3;
        int safeOutputEnd = this._outputEnd - 6;
        int chunksBeforeLF = Base64Variants.getDefaultVariant().getMaxLineLength() >> 2;
        while (inputPtr <= safeInputEnd) {
            if (this._outputTail > safeOutputEnd) {
                this._flushBuffer();
            }
            int b24 = input[inputPtr++] << 8;
            b24 |= input[inputPtr++] & 0xFF;
            b24 = b24 << 8 | input[inputPtr++] & 0xFF;
            this._outputTail = Base64Variants.getDefaultVariant().encodeBase64Chunk(b24, this._outputBuffer, this._outputTail);
            if (--chunksBeforeLF > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            chunksBeforeLF = Base64Variants.getDefaultVariant().getMaxLineLength() >> 2;
        }
        int inputLeft = inputEnd - inputPtr;
        if (inputLeft > 0) {
            if (this._outputTail > safeOutputEnd) {
                this._flushBuffer();
            }
            int b24 = input[inputPtr++] << 16;
            if (inputLeft == 2) {
                b24 |= (input[inputPtr++] & 0xFF) << 8;
            }
            this._outputTail = Base64Variants.getDefaultVariant().encodeBase64Partial(b24, inputLeft, this._outputBuffer, this._outputTail);
        }
    }

    private void _writeNull() throws IOException {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        int ptr = this._outputTail;
        char[] buf = this._outputBuffer;
        buf[ptr] = 110;
        buf[++ptr] = 117;
        buf[++ptr] = 108;
        buf[++ptr] = 108;
        this._outputTail = ptr + 1;
    }

    private void _prependOrWriteCharacterEscape(char ch, int escCode) throws IOException {
        if (escCode >= 0) {
            if (this._outputTail >= 2) {
                int ptr;
                this._outputHead = ptr = this._outputTail - 2;
                this._outputBuffer[ptr++] = 92;
                this._outputBuffer[ptr] = (char)escCode;
                return;
            }
            char[] buf = this._entityBuffer;
            if (buf == null) {
                buf = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            buf[1] = (char)escCode;
            this._writer.write(buf, 0, 2);
            return;
        }
        if (this._outputTail >= 6) {
            int ptr;
            char[] buf = this._outputBuffer;
            this._outputHead = ptr = this._outputTail - 6;
            buf[ptr] = 92;
            buf[++ptr] = 117;
            if (ch > '\u00ff') {
                int hi = ch >> 8 & 0xFF;
                buf[++ptr] = HEX_CHARS[hi >> 4];
                buf[++ptr] = HEX_CHARS[hi & 0xF];
                ch = (char)(ch & 0xFF);
            } else {
                buf[++ptr] = 48;
                buf[++ptr] = 48;
            }
            buf[++ptr] = HEX_CHARS[ch >> 4];
            buf[++ptr] = HEX_CHARS[ch & 0xF];
            return;
        }
        char[] buf = this._entityBuffer;
        if (buf == null) {
            buf = this._allocateEntityBuffer();
        }
        this._outputHead = this._outputTail;
        if (ch > '\u00ff') {
            int hi = ch >> 8 & 0xFF;
            int lo = ch & 0xFF;
            buf[10] = HEX_CHARS[hi >> 4];
            buf[11] = HEX_CHARS[hi & 0xF];
            buf[12] = HEX_CHARS[lo >> 4];
            buf[13] = HEX_CHARS[lo & 0xF];
            this._writer.write(buf, 8, 6);
        } else {
            buf[6] = HEX_CHARS[ch >> 4];
            buf[7] = HEX_CHARS[ch & 0xF];
            this._writer.write(buf, 2, 6);
        }
    }

    private int _prependOrWriteCharacterEscape(char[] buffer, int ptr, int end, char ch, int escCode) throws IOException {
        if (escCode >= 0) {
            if (ptr > 1 && ptr < end) {
                buffer[ptr -= 2] = 92;
                buffer[ptr + 1] = (char)escCode;
            } else {
                char[] ent = this._entityBuffer;
                if (ent == null) {
                    ent = this._allocateEntityBuffer();
                }
                ent[1] = (char)escCode;
                this._writer.write(ent, 0, 2);
            }
            return ptr;
        }
        if (ptr > 5 && ptr < end) {
            ptr -= 6;
            buffer[ptr++] = 92;
            buffer[ptr++] = 117;
            if (ch > '\u00ff') {
                int hi = ch >> 8 & 0xFF;
                buffer[ptr++] = HEX_CHARS[hi >> 4];
                buffer[ptr++] = HEX_CHARS[hi & 0xF];
                ch = (char)(ch & 0xFF);
            } else {
                buffer[ptr++] = 48;
                buffer[ptr++] = 48;
            }
            buffer[ptr++] = HEX_CHARS[ch >> 4];
            buffer[ptr] = HEX_CHARS[ch & 0xF];
            ptr -= 5;
        } else {
            char[] ent = this._entityBuffer;
            if (ent == null) {
                ent = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            if (ch > '\u00ff') {
                int hi = ch >> 8 & 0xFF;
                int lo = ch & 0xFF;
                ent[10] = HEX_CHARS[hi >> 4];
                ent[11] = HEX_CHARS[hi & 0xF];
                ent[12] = HEX_CHARS[lo >> 4];
                ent[13] = HEX_CHARS[lo & 0xF];
                this._writer.write(ent, 8, 6);
            } else {
                ent[6] = HEX_CHARS[ch >> 4];
                ent[7] = HEX_CHARS[ch & 0xF];
                this._writer.write(ent, 2, 6);
            }
        }
        return ptr;
    }

    private char[] _allocateEntityBuffer() {
        char[] buf = new char[14];
        buf[0] = 92;
        buf[2] = 92;
        buf[3] = 117;
        buf[4] = 48;
        buf[5] = 48;
        buf[8] = 92;
        buf[9] = 117;
        this._entityBuffer = buf;
        return buf;
    }

    protected void _flushBuffer() throws IOException {
        int len = this._outputTail - this._outputHead;
        if (len > 0) {
            int offset = this._outputHead;
            this._outputHead = 0;
            this._outputTail = 0;
            this._writer.write(this._outputBuffer, offset, len);
        }
    }

    protected void _reportCantWriteValueExpectName(String typeMsg) throws IOException {
        throw new JsonGenerationException(String.format("Can not %s, expecting field name (context: %s)", typeMsg, this._writeContext.typeDesc()), this);
    }
}

