/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.json.implementation.jackson.core.io;

import io.clientcore.core.serialization.json.implementation.jackson.core.io.CharTypes;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class ContentReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final ContentReference UNKNOWN_CONTENT = new ContentReference(false, null);
    public static final int DEFAULT_MAX_CONTENT_SNIPPET = 500;
    protected final transient Object _rawContent;
    protected final boolean _isContentTextual;

    protected ContentReference(boolean isContentTextual, Object rawContent) {
        this._isContentTextual = isContentTextual;
        this._rawContent = rawContent;
    }

    public static ContentReference unknown() {
        return UNKNOWN_CONTENT;
    }

    public static ContentReference construct(Object rawContent) {
        return new ContentReference(true, rawContent);
    }

    private void readObject(ObjectInputStream in) throws IOException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    protected Object readResolve() {
        return UNKNOWN_CONTENT;
    }

    public boolean hasTextualContent() {
        return this._isContentTextual;
    }

    public String buildSourceDescription() {
        Object srcRef = this._rawContent;
        if (srcRef == null) {
            return "UNKNOWN";
        }
        StringBuilder sb = new StringBuilder(200);
        Class<?> srcType = srcRef instanceof Class ? (Class<?>)srcRef : srcRef.getClass();
        String tn = srcType.getName();
        if (tn.startsWith("java.")) {
            tn = srcType.getSimpleName();
        } else if (srcRef instanceof byte[]) {
            tn = "byte[]";
        } else if (srcRef instanceof char[]) {
            tn = "char[]";
        }
        sb.append('(').append(tn).append(')');
        if (this.hasTextualContent()) {
            String trimmed;
            String unitStr = " chars";
            int maxLen = 500;
            int[] offsets = new int[]{-1, -1};
            if (srcRef instanceof CharSequence) {
                trimmed = this._truncate((CharSequence)srcRef, offsets);
            } else if (srcRef instanceof char[]) {
                trimmed = this._truncate((char[])srcRef, offsets);
            } else if (srcRef instanceof byte[]) {
                trimmed = this._truncate((byte[])srcRef, offsets);
                unitStr = " bytes";
            } else {
                trimmed = null;
            }
            if (trimmed != null) {
                this._append(sb, trimmed);
                if (offsets[1] > 500) {
                    sb.append("[truncated ").append(offsets[1] - 500).append(unitStr).append(']');
                }
            }
        } else if (srcRef instanceof byte[]) {
            sb.append('[').append(((byte[])srcRef).length).append(" bytes]");
        }
        return sb.toString();
    }

    protected String _truncate(CharSequence cs, int[] offsets) {
        this._truncateOffsets(offsets, cs.length());
        int start = offsets[0];
        int length = Math.min(offsets[1], 500);
        return cs.subSequence(start, start + length).toString();
    }

    protected String _truncate(char[] cs, int[] offsets) {
        this._truncateOffsets(offsets, cs.length);
        int start = offsets[0];
        int length = Math.min(offsets[1], 500);
        return new String(cs, start, length);
    }

    protected String _truncate(byte[] b, int[] offsets) {
        this._truncateOffsets(offsets, b.length);
        int start = offsets[0];
        int length = Math.min(offsets[1], 500);
        return new String(b, start, length, StandardCharsets.UTF_8);
    }

    protected void _truncateOffsets(int[] offsets, int actualLength) {
        int start = offsets[0];
        if (start < 0) {
            start = 0;
        } else if (start >= actualLength) {
            start = actualLength;
        }
        offsets[0] = start;
        int length = offsets[1];
        int maxLength = actualLength - start;
        if (length < 0 || length > maxLength) {
            offsets[1] = maxLength;
        }
    }

    protected void _append(StringBuilder sb, String content) {
        sb.append('\"');
        int end = content.length();
        for (int i = 0; i < end; ++i) {
            char ch = content.charAt(i);
            if (Character.isISOControl(ch) && this._appendEscaped(sb, ch)) continue;
            sb.append(ch);
        }
        sb.append('\"');
    }

    protected boolean _appendEscaped(StringBuilder sb, int ctrlChar) {
        if (ctrlChar == 13 || ctrlChar == 10) {
            return false;
        }
        sb.append('\\');
        sb.append('u');
        sb.append(CharTypes.hexToChar(ctrlChar >> 12 & 0xF));
        sb.append(CharTypes.hexToChar(ctrlChar >> 8 & 0xF));
        sb.append(CharTypes.hexToChar(ctrlChar >> 4 & 0xF));
        sb.append(CharTypes.hexToChar(ctrlChar & 0xF));
        return true;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof ContentReference)) {
            return false;
        }
        ContentReference otherSrc = (ContentReference)other;
        Object otherRaw = otherSrc._rawContent;
        if (this._rawContent == null) {
            return otherRaw == null;
        }
        if (otherRaw == null) {
            return false;
        }
        if (this._rawContent instanceof File || this._rawContent instanceof URL || this._rawContent instanceof URI) {
            return this._rawContent.equals(otherRaw);
        }
        return this._rawContent == otherSrc._rawContent;
    }

    public int hashCode() {
        return Objects.hashCode(this._rawContent);
    }
}

