/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.json.implementation.jackson.core;

import io.clientcore.core.serialization.json.implementation.jackson.core.JsonLocation;
import io.clientcore.core.serialization.json.implementation.jackson.core.JsonParseException;
import io.clientcore.core.serialization.json.implementation.jackson.core.JsonStreamContext;
import io.clientcore.core.serialization.json.implementation.jackson.core.JsonToken;
import io.clientcore.core.serialization.json.implementation.jackson.core.util.RequestPayload;
import java.io.Closeable;
import java.io.IOException;

public abstract class JsonParser
implements Closeable {
    protected int _features;
    protected transient RequestPayload _requestPayload;

    protected JsonParser() {
    }

    protected JsonParser(int features) {
        this._features = features;
    }

    @Override
    public abstract void close() throws IOException;

    public abstract JsonStreamContext getParsingContext();

    public abstract JsonLocation getCurrentLocation();

    public final JsonParser configure(Feature f, boolean state) {
        this._features = state ? (this._features |= f.getMask()) : (this._features &= ~f.getMask());
        return this;
    }

    public abstract JsonToken nextToken() throws IOException;

    public abstract JsonParser skipChildren() throws IOException;

    public abstract JsonToken getCurrentToken();

    public abstract String getCurrentName() throws IOException;

    public abstract String getText() throws IOException;

    public abstract int getIntValue() throws IOException;

    public abstract long getLongValue() throws IOException;

    public abstract float getFloatValue() throws IOException;

    public abstract double getDoubleValue() throws IOException;

    public boolean getBooleanValue() throws IOException {
        JsonToken t = this.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return false;
        }
        throw new JsonParseException(this, String.format("Current token (%s) not of boolean type", new Object[]{t})).withRequestPayload(this._requestPayload);
    }

    public abstract byte[] getBinaryValue() throws IOException;

    public abstract String getValueAsString() throws IOException;

    protected JsonParseException _constructError(String msg) {
        return new JsonParseException(this, msg).withRequestPayload(this._requestPayload);
    }

    public static enum Feature {
        ALLOW_COMMENTS(false),
        ALLOW_NON_NUMERIC_NUMBERS(false);

        private final boolean _defaultState;
        private final int _mask = 1 << this.ordinal();

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

