/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.json;

import io.clientcore.core.serialization.json.JsonWriter;
import io.clientcore.core.serialization.json.implementation.StringBuilderWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public interface JsonSerializable<T extends JsonSerializable<T>> {
    public JsonWriter toJson(JsonWriter var1) throws IOException;

    default public void toJson(OutputStream outputStream) throws IOException {
        try (JsonWriter jsonWriter = JsonWriter.toStream(outputStream);){
            this.toJson(jsonWriter).flush();
        }
    }

    default public void toJson(Writer writer) throws IOException {
        try (JsonWriter jsonWriter = JsonWriter.toWriter(writer);){
            this.toJson(jsonWriter).flush();
        }
    }

    default public String toJsonString() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        try (JsonWriter jsonWriter = JsonWriter.toWriter(writer);){
            this.toJson(jsonWriter).flush();
            String string = writer.toString();
            return string;
        }
    }

    default public byte[] toJsonBytes() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (JsonWriter jsonWriter = JsonWriter.toStream(outputStream);){
            this.toJson(jsonWriter).flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }
}

