/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.json;

import io.clientcore.core.serialization.json.JsonOptions;
import io.clientcore.core.serialization.json.JsonToken;
import io.clientcore.core.serialization.json.implementation.JsonUtils;
import io.clientcore.core.serialization.json.implementation.jackson.core.JsonFactory;
import io.clientcore.core.serialization.json.implementation.jackson.core.JsonParser;
import io.clientcore.core.serialization.json.implementation.jackson.core.io.JsonStringEncoder;
import io.clientcore.core.utils.IOExceptionCheckedFunction;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class JsonReader
implements Closeable {
    private static final JsonFactory FACTORY = new JsonFactory();
    private final JsonParser parser;
    private final Reader jsonReader;
    private final boolean resetSupported;
    private final boolean jsoncSupported;
    private JsonToken currentToken;

    private JsonReader(JsonParser parser, boolean resetSupported, Reader jsonReader, JsonOptions options) {
        this.parser = parser;
        if (options != null) {
            this.parser.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true).configure(JsonParser.Feature.ALLOW_COMMENTS, options.isJsoncSupported());
            this.jsoncSupported = options.isJsoncSupported();
        } else {
            this.parser.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
            this.jsoncSupported = false;
        }
        this.resetSupported = resetSupported;
        this.jsonReader = jsonReader;
    }

    private JsonReader(JsonParser parser, boolean resetSupported, Reader jsonReader, boolean jsoncSupported) {
        this.parser = parser.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true).configure(JsonParser.Feature.ALLOW_COMMENTS, jsoncSupported);
        this.resetSupported = resetSupported;
        this.jsonReader = jsonReader;
        this.jsoncSupported = jsoncSupported;
    }

    public static JsonReader fromBytes(byte[] json) throws IOException {
        return JsonReader.fromStream(new ByteArrayInputStream(json), null);
    }

    public static JsonReader fromBytes(byte[] json, JsonOptions options) throws IOException {
        return JsonReader.fromStream(new ByteArrayInputStream(json), options);
    }

    public static JsonReader fromString(String json) throws IOException {
        return JsonReader.fromReader(new StringReader(json), null);
    }

    public static JsonReader fromString(String json, JsonOptions options) throws IOException {
        return JsonReader.fromReader(new StringReader(json), options);
    }

    public static JsonReader fromStream(InputStream json) throws IOException {
        return JsonReader.fromReader(new InputStreamReader(json), null);
    }

    public static JsonReader fromStream(InputStream json, JsonOptions options) throws IOException {
        return JsonReader.fromReader(new InputStreamReader(json), options);
    }

    public static JsonReader fromReader(Reader reader) throws IOException {
        return JsonReader.fromReader(reader, null);
    }

    public static JsonReader fromReader(Reader reader, JsonOptions options) throws IOException {
        return new JsonReader(FACTORY.createParser(reader), reader.markSupported(), reader, options);
    }

    public JsonToken currentToken() {
        return this.currentToken;
    }

    public JsonToken nextToken() throws IOException {
        this.currentToken = JsonReader.mapToken(this.parser.nextToken(), this.currentToken);
        return this.currentToken;
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }

    public boolean isStartArrayOrObject() {
        return JsonReader.isStartArrayOrObject(this.currentToken());
    }

    private static boolean isStartArrayOrObject(JsonToken token) {
        return token == JsonToken.START_ARRAY || token == JsonToken.START_OBJECT;
    }

    public boolean isEndArrayOrObject() {
        return JsonReader.isEndArrayOrObject(this.currentToken());
    }

    private static boolean isEndArrayOrObject(JsonToken token) {
        return token == JsonToken.END_ARRAY || token == JsonToken.END_OBJECT;
    }

    public byte[] getBinary() throws IOException {
        if (this.currentToken() == JsonToken.NULL) {
            return null;
        }
        return this.parser.getBinaryValue();
    }

    public boolean getBoolean() throws IOException {
        return this.parser.getBooleanValue();
    }

    public float getFloat() throws IOException {
        return this.parser.getFloatValue();
    }

    public double getDouble() throws IOException {
        return this.parser.getDoubleValue();
    }

    public int getInt() throws IOException {
        return this.parser.getIntValue();
    }

    public long getLong() throws IOException {
        return this.parser.getLongValue();
    }

    public String getString() throws IOException {
        return this.parser.getValueAsString();
    }

    public String getFieldName() throws IOException {
        return this.parser.getCurrentName();
    }

    public <T> T getNullable(IOExceptionCheckedFunction<JsonReader, T> nonNullGetter) throws IOException {
        return this.currentToken() == JsonToken.NULL ? null : (T)nonNullGetter.apply(this);
    }

    public void skipChildren() throws IOException {
        this.parser.skipChildren();
    }

    public JsonReader bufferObject() throws IOException {
        JsonToken currentToken = this.currentToken();
        if (currentToken == JsonToken.START_OBJECT || currentToken == JsonToken.FIELD_NAME) {
            StringReader jsonReader = new StringReader(this.readRemainingFieldsAsJsonObject());
            return new JsonReader(FACTORY.createParser(jsonReader), ((Reader)jsonReader).markSupported(), (Reader)jsonReader, this.jsoncSupported);
        }
        throw new IllegalStateException("Cannot buffer a JSON object from a non-object, non-field name starting location. Starting location: " + (Object)((Object)this.currentToken()));
    }

    public boolean isResetSupported() {
        return this.resetSupported;
    }

    public JsonReader reset() throws IOException {
        if (!this.resetSupported) {
            throw new IllegalStateException("'reset' isn't supported by this JsonReader.");
        }
        this.jsonReader.reset();
        return new JsonReader(FACTORY.createParser(this.jsonReader), true, this.jsonReader, this.jsoncSupported);
    }

    public String readChildren() throws IOException {
        return this.readInternal(new StringBuilder(), true, false).toString();
    }

    public void readChildren(StringBuilder buffer) throws IOException {
        this.readInternal(buffer, true, false);
    }

    public String readRemainingFieldsAsJsonObject() throws IOException {
        return this.readInternal(new StringBuilder(), false, true).toString();
    }

    public void readRemainingFieldsAsJsonObject(StringBuilder buffer) throws IOException {
        this.readInternal(buffer, false, true);
    }

    private StringBuilder readInternal(StringBuilder buffer, boolean canStartAtArray, boolean canStartAtFieldName) throws IOException {
        boolean canRead;
        Objects.requireNonNull(buffer, "The 'buffer' used to read the JSON object cannot be null.");
        JsonToken token = this.currentToken();
        boolean bl = canRead = token == JsonToken.START_OBJECT || canStartAtArray && token == JsonToken.START_ARRAY || canStartAtFieldName && token == JsonToken.FIELD_NAME;
        if (!canRead) {
            return buffer;
        }
        if (token == JsonToken.FIELD_NAME) {
            buffer.append("{\"");
            JsonStringEncoder.quoteAsString(this.getFieldName(), buffer);
            buffer.append("\":");
            token = this.nextToken();
        }
        this.appendJson(buffer, token);
        int depth = 1;
        while (depth > 0) {
            JsonToken previousToken = token;
            token = this.nextToken();
            if (JsonReader.isStartArrayOrObject(token)) {
                ++depth;
            } else if (JsonReader.isEndArrayOrObject(token)) {
                --depth;
            } else if (token == null) {
                return buffer;
            }
            if (!JsonReader.isStartArrayOrObject(previousToken) && !JsonReader.isEndArrayOrObject(token) && previousToken != JsonToken.FIELD_NAME) {
                buffer.append(',');
            }
            this.appendJson(buffer, token);
        }
        return buffer;
    }

    private void appendJson(StringBuilder buffer, JsonToken token) throws IOException {
        if (token == JsonToken.FIELD_NAME) {
            buffer.append("\"");
            JsonStringEncoder.quoteAsString(this.getFieldName(), buffer);
            buffer.append("\":");
        } else if (token == JsonToken.STRING) {
            buffer.append("\"");
            JsonStringEncoder.quoteAsString(this.getString(), buffer);
            buffer.append("\"");
        } else {
            buffer.append(this.getText());
        }
    }

    public <T> T readObject(IOExceptionCheckedFunction<JsonReader, T> objectReaderFunc) throws IOException {
        return this.readMapOrObject(objectReaderFunc, false);
    }

    public <T> List<T> readArray(IOExceptionCheckedFunction<JsonReader, T> elementReaderFunc) throws IOException {
        JsonToken currentToken = this.currentToken();
        if (currentToken == null) {
            currentToken = this.nextToken();
        }
        if (currentToken == JsonToken.NULL || currentToken == null) {
            return null;
        }
        if (currentToken != JsonToken.START_ARRAY) {
            throw new IllegalStateException("Unexpected token to begin array deserialization: " + (Object)((Object)currentToken));
        }
        LinkedList<T> array = new LinkedList<T>();
        while (this.nextToken() != JsonToken.END_ARRAY) {
            array.add(elementReaderFunc.apply(this));
        }
        return array;
    }

    public <T> Map<String, T> readMap(IOExceptionCheckedFunction<JsonReader, T> valueReaderFunc) throws IOException {
        return this.readMapOrObject(reader -> {
            LinkedHashMap map = new LinkedHashMap();
            while (this.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = this.getFieldName();
                this.nextToken();
                map.put(fieldName, valueReaderFunc.apply(this));
            }
            return map;
        }, true);
    }

    private <T> T readMapOrObject(IOExceptionCheckedFunction<JsonReader, T> valueReaderFunc, boolean isMap) throws IOException {
        JsonToken currentToken = this.currentToken();
        if (currentToken == null) {
            currentToken = this.nextToken();
        }
        if (currentToken == JsonToken.NULL || currentToken == null) {
            return null;
        }
        if (currentToken != JsonToken.START_OBJECT) {
            String type = isMap ? "map" : "object";
            throw new IllegalStateException("Unexpected token to begin " + type + " deserialization: " + (Object)((Object)currentToken));
        }
        return valueReaderFunc.apply(this);
    }

    public Object readUntyped() throws IOException {
        JsonToken token = this.currentToken();
        if (token == null) {
            token = this.nextToken();
        }
        if (token == JsonToken.END_ARRAY || token == JsonToken.END_OBJECT || token == JsonToken.FIELD_NAME) {
            throw new IllegalStateException("Unexpected token to begin an untyped field: " + (Object)((Object)token));
        }
        return this.readUntypedHelper(0);
    }

    private Object readUntypedHelper(int depth) throws IOException {
        if (depth >= 999) {
            throw new IllegalStateException("Untyped object exceeded allowed object nested depth of 1000.");
        }
        JsonToken token = this.currentToken();
        if (token == JsonToken.NULL || token == null) {
            return null;
        }
        if (token == JsonToken.BOOLEAN) {
            return this.getBoolean();
        }
        if (token == JsonToken.NUMBER) {
            return JsonUtils.parseNumber(this.getText());
        }
        if (token == JsonToken.STRING) {
            return this.getString();
        }
        if (token == JsonToken.START_ARRAY) {
            ArrayList<Object> array = new ArrayList<Object>();
            while (this.nextToken() != JsonToken.END_ARRAY) {
                array.add(this.readUntypedHelper(depth + 1));
            }
            return array;
        }
        if (token == JsonToken.START_OBJECT) {
            LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
            while (this.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = this.getFieldName();
                this.nextToken();
                Object value = this.readUntypedHelper(depth + 1);
                object.put(fieldName, value);
            }
            return object;
        }
        throw new IllegalStateException("Unknown token type while reading an untyped field: " + (Object)((Object)token));
    }

    public String getText() throws IOException {
        return this.getTextInternal(false);
    }

    public String getRawText() throws IOException {
        return this.getTextInternal(true);
    }

    private String getTextInternal(boolean raw) throws IOException {
        JsonToken token = this.currentToken();
        if (token == null) {
            throw new IllegalStateException("Current token cannot be null.");
        }
        switch (token) {
            case START_OBJECT: {
                return "{";
            }
            case END_OBJECT: {
                return "}";
            }
            case START_ARRAY: {
                return "[";
            }
            case END_ARRAY: {
                return "]";
            }
            case FIELD_NAME: {
                return raw ? new String(JsonStringEncoder.quoteAsUTF8(this.getFieldName()), StandardCharsets.UTF_8) : this.getFieldName();
            }
            case BOOLEAN: {
                return String.valueOf(this.getBoolean());
            }
            case NUMBER: {
                return this.getString();
            }
            case STRING: {
                return raw ? new String(JsonStringEncoder.quoteAsUTF8(this.getString()), StandardCharsets.UTF_8) : this.getString();
            }
            case NULL: {
                return "null";
            }
        }
        return "";
    }

    private static JsonToken mapToken(io.clientcore.core.serialization.json.implementation.jackson.core.JsonToken nextToken, JsonToken currentToken) {
        if (nextToken == null && currentToken == null) {
            return null;
        }
        if (nextToken == null) {
            return JsonToken.END_DOCUMENT;
        }
        switch (nextToken) {
            case START_OBJECT: {
                return JsonToken.START_OBJECT;
            }
            case END_OBJECT: {
                return JsonToken.END_OBJECT;
            }
            case START_ARRAY: {
                return JsonToken.START_ARRAY;
            }
            case END_ARRAY: {
                return JsonToken.END_ARRAY;
            }
            case FIELD_NAME: {
                return JsonToken.FIELD_NAME;
            }
            case VALUE_STRING: {
                return JsonToken.STRING;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return JsonToken.NUMBER;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                return JsonToken.BOOLEAN;
            }
            case VALUE_NULL: {
                return JsonToken.NULL;
            }
        }
        throw new IllegalStateException("Unsupported token type: '" + (Object)((Object)nextToken) + "'.");
    }
}

