/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization;

import io.clientcore.core.serialization.SerializationFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public interface ObjectSerializer {
    public <T> T deserializeFromBytes(byte[] var1, Type var2) throws IOException;

    public <T> T deserializeFromStream(InputStream var1, Type var2) throws IOException;

    default public <T> T deserializeFromChannel(ReadableByteChannel channel, Type type) throws IOException {
        return this.deserializeFromStream(Channels.newInputStream(channel), type);
    }

    public byte[] serializeToBytes(Object var1) throws IOException;

    public void serializeToStream(OutputStream var1, Object var2) throws IOException;

    default public void serializeToChannel(WritableByteChannel channel, Object value) throws IOException {
        this.serializeToStream(Channels.newOutputStream(channel), value);
    }

    public boolean supportsFormat(SerializationFormat var1);
}

