/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.models.geo;

import io.clientcore.core.models.geo.GeoBoundingBox;
import io.clientcore.core.models.geo.GeoObject;
import io.clientcore.core.models.geo.GeoObjectType;
import io.clientcore.core.models.geo.GeoPosition;
import io.clientcore.core.serialization.json.JsonReader;
import io.clientcore.core.serialization.json.JsonToken;
import io.clientcore.core.serialization.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class GeoPoint
extends GeoObject {
    private final GeoPosition coordinates;

    public GeoPoint(double longitude, double latitude) {
        this(longitude, latitude, null);
    }

    public GeoPoint(double longitude, double latitude, Double altitude) {
        this(new GeoPosition(longitude, latitude, altitude));
    }

    public GeoPoint(GeoPosition position) {
        this(position, null, null);
    }

    public GeoPoint(GeoPosition position, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        super(boundingBox, customProperties);
        this.coordinates = Objects.requireNonNull(position, "'position' cannot be null.");
    }

    public GeoPosition getCoordinates() {
        return this.coordinates;
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.POINT;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.coordinates, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeoPoint)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoPoint other = (GeoPoint)obj;
        return super.equals(obj) && Objects.equals(this.coordinates, other.coordinates);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("type", GeoObjectType.POINT.toString()).writeJsonField("coordinates", this.coordinates).writeJsonField("bbox", this.getBoundingBox());
        return this.writeCustomProperties(jsonWriter).writeEndObject();
    }

    public static GeoPoint fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GeoPosition position = null;
            boolean positionFound = false;
            GeoBoundingBox boundingBox = null;
            LinkedHashMap<String, Object> customProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    String type = reader.getString();
                    if (GeoObjectType.POINT.toString().equals(type)) continue;
                    throw new IllegalStateException("'type' was expected to be non-null and equal to 'Point'. The found 'type' was '" + type + "'.");
                }
                if ("coordinates".equals(fieldName)) {
                    positionFound = true;
                    position = GeoPosition.fromJson(reader);
                    continue;
                }
                if ("bbox".equals(fieldName)) {
                    boundingBox = GeoBoundingBox.fromJson(reader);
                    continue;
                }
                if (customProperties == null) {
                    customProperties = new LinkedHashMap<String, Object>();
                }
                customProperties.put(fieldName, reader.readUntyped());
            }
            if (!positionFound) {
                throw new IllegalStateException("Required property 'coordinates' wasn't found.");
            }
            return new GeoPoint(position, boundingBox, customProperties);
        });
    }
}

