/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.models.geo;

import io.clientcore.core.models.geo.GeoArray;
import io.clientcore.core.models.geo.GeoBoundingBox;
import io.clientcore.core.models.geo.GeoObject;
import io.clientcore.core.models.geo.GeoObjectType;
import io.clientcore.core.models.geo.GeoPosition;
import io.clientcore.core.serialization.json.JsonReader;
import io.clientcore.core.serialization.json.JsonToken;
import io.clientcore.core.serialization.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class GeoLineString
extends GeoObject {
    private final GeoArray<GeoPosition> coordinates;

    public GeoLineString(List<GeoPosition> positions) {
        this(positions, null, null);
    }

    public GeoLineString(List<GeoPosition> positions, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        super(boundingBox, customProperties);
        Objects.requireNonNull(positions, "'positions' cannot be null.");
        this.coordinates = new GeoArray(new ArrayList<GeoPosition>(positions));
    }

    public List<GeoPosition> getCoordinates() {
        return this.coordinates;
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.LINE_STRING;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.coordinates, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeoLineString)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoLineString other = (GeoLineString)obj;
        return super.equals(other) && Objects.equals(this.coordinates, other.coordinates);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("type", GeoObjectType.LINE_STRING.toString()).writeArrayField("coordinates", this.getCoordinates(), JsonWriter::writeJson).writeJsonField("bbox", this.getBoundingBox());
        return this.writeCustomProperties(jsonWriter).writeEndObject();
    }

    public static GeoLineString fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<GeoPosition> coordinates = null;
            GeoBoundingBox boundingBox = null;
            LinkedHashMap<String, Object> customProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    String type = reader.getString();
                    if (GeoObjectType.LINE_STRING.toString().equals(type)) continue;
                    throw new IllegalStateException("'type' was expected to be non-null and equal to 'LineString'. The found 'type' was '" + type + "'.");
                }
                if ("coordinates".equals(fieldName)) {
                    coordinates = reader.readArray(GeoPosition::fromJson);
                    continue;
                }
                if ("bbox".equals(fieldName)) {
                    boundingBox = GeoBoundingBox.fromJson(reader);
                    continue;
                }
                if (customProperties == null) {
                    customProperties = new LinkedHashMap<String, Object>();
                }
                customProperties.put(fieldName, reader.readUntyped());
            }
            return new GeoLineString(coordinates, boundingBox, customProperties);
        });
    }
}

