/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.models.binarydata;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.CoreException;
import io.clientcore.core.models.binarydata.ByteArrayBinaryData;
import io.clientcore.core.models.binarydata.ByteBufferBinaryData;
import io.clientcore.core.models.binarydata.FileBinaryData;
import io.clientcore.core.models.binarydata.InputStreamBinaryData;
import io.clientcore.core.models.binarydata.ListByteBufferBinaryData;
import io.clientcore.core.models.binarydata.SerializableBinaryData;
import io.clientcore.core.models.binarydata.StringBinaryData;
import io.clientcore.core.serialization.ObjectSerializer;
import io.clientcore.core.serialization.json.JsonSerializer;
import io.clientcore.core.serialization.json.JsonWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.util.List;

public abstract class BinaryData
implements Closeable {
    private static final BinaryData EMPTY = BinaryData.fromBytes(new byte[0]);
    private static final ClientLogger LOGGER = new ClientLogger(BinaryData.class);
    static final ObjectSerializer SERIALIZER = new JsonSerializer();
    static final int STREAM_READ_SIZE = 8192;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    static final String TOO_LARGE_FOR_BYTE_ARRAY = "The content length is too large for a byte array. Content length is: ";

    public static BinaryData fromStream(InputStream inputStream) {
        return BinaryData.fromStream(inputStream, null);
    }

    public static BinaryData fromStream(InputStream inputStream, Long length) {
        return new InputStreamBinaryData(inputStream, length);
    }

    public static BinaryData fromString(String data) {
        return new StringBinaryData(data);
    }

    public static BinaryData fromBytes(byte[] data) {
        return new ByteArrayBinaryData(data);
    }

    static BinaryData fromByteBuffer(ByteBuffer data) {
        return new ByteBufferBinaryData(data);
    }

    static BinaryData fromListByteBuffer(List<ByteBuffer> data) {
        return new ListByteBufferBinaryData(data);
    }

    public static BinaryData fromObject(Object data) {
        return BinaryData.fromObject(data, SERIALIZER);
    }

    public static BinaryData fromObject(Object data, ObjectSerializer serializer) {
        return new SerializableBinaryData(data, serializer);
    }

    public static BinaryData fromFile(Path file) {
        return BinaryData.fromFile(file, 8192);
    }

    public static BinaryData fromFile(Path file, int chunkSize) {
        return new FileBinaryData(file, chunkSize, null, null);
    }

    public static BinaryData fromFile(Path file, Long position, Long length) {
        return new FileBinaryData(file, 8192, position, length);
    }

    public static BinaryData fromFile(Path file, Long position, Long length, int chunkSize) {
        return new FileBinaryData(file, chunkSize, position, length);
    }

    public abstract byte[] toBytes();

    public abstract String toString();

    public <T> T toObject(Type type) {
        return this.toObject(type, SERIALIZER);
    }

    public abstract <T> T toObject(Type var1, ObjectSerializer var2);

    public abstract InputStream toStream();

    public void writeTo(OutputStream outputStream) {
        try {
            outputStream.write(this.toBytes());
        }
        catch (IOException e) {
            throw LOGGER.logThrowableAsError(CoreException.from(e));
        }
    }

    public void writeTo(WritableByteChannel channel) {
        try {
            ByteBuffer buffer = this.toByteBuffer().duplicate();
            while (buffer.hasRemaining()) {
                channel.write(buffer);
            }
        }
        catch (IOException e) {
            throw LOGGER.logThrowableAsError(CoreException.from(e));
        }
    }

    public abstract void writeTo(JsonWriter var1);

    public abstract ByteBuffer toByteBuffer();

    public abstract Long getLength();

    public abstract boolean isReplayable();

    public abstract BinaryData toReplayableBinaryData();

    public static BinaryData empty() {
        return EMPTY;
    }

    @Override
    public void close() {
    }
}

