/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.instrumentation;

import io.clientcore.core.implementation.instrumentation.SdkInstrumentationOptionsAccessHelper;
import java.util.Objects;

public final class SdkInstrumentationOptions {
    private final String sdkName;
    private String sdkVersion;
    private String schemaUrl;
    private boolean disableSpanSuppression;
    private String serviceEndpoint;

    public SdkInstrumentationOptions(String sdkName) {
        this.sdkName = Objects.requireNonNull(sdkName, "'sdkName' cannot be null.");
    }

    public SdkInstrumentationOptions setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
        return this;
    }

    public SdkInstrumentationOptions setSchemaUrl(String schemaUrl) {
        this.schemaUrl = schemaUrl;
        return this;
    }

    public SdkInstrumentationOptions setEndpoint(String endpoint) {
        this.serviceEndpoint = endpoint;
        return this;
    }

    public String getSdkName() {
        return this.sdkName;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String getSchemaUrl() {
        return this.schemaUrl;
    }

    public String getEndpoint() {
        return this.serviceEndpoint;
    }

    SdkInstrumentationOptions disableSpanSuppression(boolean disableSpanSuppression) {
        this.disableSpanSuppression = disableSpanSuppression;
        return this;
    }

    boolean isSpanSuppressionDisabled() {
        return this.disableSpanSuppression;
    }

    static {
        SdkInstrumentationOptionsAccessHelper.setAccessor(new SdkInstrumentationOptionsAccessHelper.SdkInstrumentationOptionsAccessor(){

            @Override
            public SdkInstrumentationOptions disableSpanSuppression(SdkInstrumentationOptions options) {
                return options.disableSpanSuppression(true);
            }

            @Override
            public boolean isSpanSuppressionDisabled(SdkInstrumentationOptions options) {
                return options.isSpanSuppressionDisabled();
            }
        });
    }
}

