/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.utils;

import io.clientcore.core.implementation.utils.UriToken;
import io.clientcore.core.implementation.utils.UriTokenizerState;

public final class UriTokenizer {
    private final String text;
    private final int textLength;
    private UriTokenizerState state;
    private int currentIndex;
    private UriToken currentToken;

    public UriTokenizer(String text, UriTokenizerState state) {
        this.text = text;
        this.textLength = text == null ? 0 : text.length();
        this.state = state;
        this.currentIndex = 0;
        this.currentToken = null;
    }

    private boolean hasCurrentCharacter() {
        return this.currentIndex < this.textLength;
    }

    private char currentCharacter() {
        return this.text.charAt(this.currentIndex);
    }

    private void nextCharacter() {
        if (this.hasCurrentCharacter()) {
            ++this.currentIndex;
        }
    }

    private boolean peekMatchesSchemeSeparator(boolean step) {
        if ("://".regionMatches(0, this.text, this.currentIndex, 3)) {
            if (step) {
                this.currentIndex += 3;
            }
            return true;
        }
        return false;
    }

    public UriToken current() {
        return this.currentToken;
    }

    public boolean next() {
        if (!this.hasCurrentCharacter()) {
            this.currentToken = null;
        } else {
            switch (this.state) {
                case SCHEME: {
                    String scheme = this.readUntilNotLetterOrDigit();
                    this.currentToken = UriToken.scheme(scheme);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UriTokenizerState.DONE;
                        break;
                    }
                    this.state = UriTokenizerState.HOST;
                    break;
                }
                case SCHEME_OR_HOST: {
                    String schemeOrHost = this.readUntil(true);
                    if (!this.hasCurrentCharacter()) {
                        this.currentToken = UriToken.host(schemeOrHost);
                        this.state = UriTokenizerState.DONE;
                        break;
                    }
                    char c = this.currentCharacter();
                    if (c == ':') {
                        if (this.peekMatchesSchemeSeparator(false)) {
                            this.currentToken = UriToken.scheme(schemeOrHost);
                            this.state = UriTokenizerState.HOST;
                            break;
                        }
                        this.currentToken = UriToken.host(schemeOrHost);
                        this.state = UriTokenizerState.PORT;
                        break;
                    }
                    if (c == '/') {
                        this.currentToken = UriToken.host(schemeOrHost);
                        this.state = UriTokenizerState.PATH;
                        break;
                    }
                    if (c != '?') break;
                    this.currentToken = UriToken.host(schemeOrHost);
                    this.state = UriTokenizerState.QUERY;
                    break;
                }
                case HOST: {
                    this.peekMatchesSchemeSeparator(true);
                    String host = this.readUntil(true);
                    this.currentToken = UriToken.host(host);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UriTokenizerState.DONE;
                        break;
                    }
                    char c = this.currentCharacter();
                    if (c == ':') {
                        this.state = UriTokenizerState.PORT;
                        break;
                    }
                    if (c == '/') {
                        this.state = UriTokenizerState.PATH;
                        break;
                    }
                    this.state = UriTokenizerState.QUERY;
                    break;
                }
                case PORT: {
                    char c = this.currentCharacter();
                    if (c == ':') {
                        this.nextCharacter();
                    }
                    String port = this.readUntil(false);
                    this.currentToken = UriToken.port(port);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UriTokenizerState.DONE;
                        break;
                    }
                    if (this.currentCharacter() == '/') {
                        this.state = UriTokenizerState.PATH;
                        break;
                    }
                    this.state = UriTokenizerState.QUERY;
                    break;
                }
                case PATH: {
                    String path;
                    int index = this.text.indexOf(63, this.currentIndex);
                    if (index == -1) {
                        path = this.text.substring(this.currentIndex);
                        this.currentIndex = this.textLength;
                    } else {
                        path = this.text.substring(this.currentIndex, index);
                        this.currentIndex = index;
                    }
                    this.currentToken = UriToken.path(path);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UriTokenizerState.DONE;
                        break;
                    }
                    this.state = UriTokenizerState.QUERY;
                    break;
                }
                case QUERY: {
                    if (this.currentCharacter() == '?') {
                        this.nextCharacter();
                    }
                    String query = this.readRemaining();
                    this.currentToken = UriToken.query(query);
                    this.state = UriTokenizerState.DONE;
                    break;
                }
            }
        }
        return this.currentToken != null;
    }

    private String readUntilNotLetterOrDigit() {
        if (!this.hasCurrentCharacter()) {
            return "";
        }
        int start = this.currentIndex;
        while (this.hasCurrentCharacter()) {
            char currentCharacter = this.currentCharacter();
            if (!Character.isLetterOrDigit(currentCharacter)) {
                return this.text.substring(start, this.currentIndex);
            }
            this.nextCharacter();
        }
        return this.text.substring(start);
    }

    private String readUntil(boolean checkForColon) {
        if (!this.hasCurrentCharacter()) {
            return "";
        }
        int start = this.currentIndex;
        while (this.hasCurrentCharacter()) {
            char c = this.currentCharacter();
            if (checkForColon && c == ':' || c == '/' || c == '?') {
                return this.text.substring(start, this.currentIndex);
            }
            this.nextCharacter();
        }
        return this.text.substring(start);
    }

    private String readRemaining() {
        String result = "";
        if (this.currentIndex < this.textLength) {
            result = this.text.substring(this.currentIndex, this.textLength);
            this.currentIndex = this.textLength;
        }
        return result;
    }
}

