/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.utils;

import io.clientcore.core.implementation.utils.UriTokenType;
import java.util.Objects;

public final class UriToken {
    private final String text;
    private final UriTokenType type;

    public UriToken(String text, UriTokenType type) {
        this.text = text;
        this.type = type;
    }

    public String text() {
        return this.text;
    }

    public UriTokenType type() {
        return this.type;
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (!(rhs instanceof UriToken)) {
            return false;
        }
        UriToken other = (UriToken)rhs;
        return this.type == other.type && Objects.equals(this.text, other.text);
    }

    public String toString() {
        return "\"" + this.text + "\" (" + (Object)((Object)this.type) + ")";
    }

    public int hashCode() {
        return (this.text == null ? 0 : this.text.hashCode()) ^ this.type.hashCode();
    }

    static UriToken scheme(String text) {
        return new UriToken(text, UriTokenType.SCHEME);
    }

    static UriToken host(String text) {
        return new UriToken(text, UriTokenType.HOST);
    }

    static UriToken port(String text) {
        return new UriToken(text, UriTokenType.PORT);
    }

    static UriToken path(String text) {
        return new UriToken(text, UriTokenType.PATH);
    }

    static UriToken query(String text) {
        return new UriToken(text, UriTokenType.QUERY);
    }
}

