/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.utils;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.utils.CoreUtils;
import java.util.Arrays;

public final class PercentEscaper {
    private static final char[] HEX_CHARACTERS = "0123456789ABCDEF".toCharArray();
    private static final boolean[] SAFE_CHARACTERS = new boolean[256];
    private static final ClientLogger LOGGER;
    private final boolean usePlusForSpace;
    private final boolean[] safeCharacterPoints;

    public PercentEscaper(String safeCharacters, boolean usePlusForSpace) {
        this.usePlusForSpace = usePlusForSpace;
        if (usePlusForSpace && safeCharacters != null && safeCharacters.contains(" ")) {
            throw LOGGER.logThrowableAsError(new IllegalArgumentException("' ' as a safe character with 'usePlusForSpace = true' is an invalid configuration."));
        }
        this.safeCharacterPoints = Arrays.copyOf(SAFE_CHARACTERS, 256);
        if (!CoreUtils.isNullOrEmpty(safeCharacters)) {
            safeCharacters.codePoints().forEach(c -> {
                this.safeCharacterPoints[c] = true;
            });
        }
    }

    public String escape(String original) {
        if (CoreUtils.isNullOrEmpty(original)) {
            return original;
        }
        StringBuilder escapedBuilder = null;
        int last = 0;
        int index = 0;
        int end = original.length();
        char[] buffer = new char[12];
        while (index < end) {
            int codePoint = PercentEscaper.getCodePoint(original, index, end);
            int toIndex = index++;
            if (codePoint < 256 && this.safeCharacterPoints[codePoint]) continue;
            index += Character.isSupplementaryCodePoint(codePoint) ? 2 : 1;
            if (escapedBuilder == null) {
                escapedBuilder = new StringBuilder((int)Math.ceil((double)original.length() * 1.5));
            }
            escapedBuilder.append(original, last, toIndex);
            last = index;
            if (this.usePlusForSpace && codePoint == 32) {
                escapedBuilder.append('+');
                continue;
            }
            if (codePoint <= 127) {
                escapedBuilder.append('%');
                escapedBuilder.append(HEX_CHARACTERS[codePoint >>> 4]);
                escapedBuilder.append(HEX_CHARACTERS[codePoint & 0xF]);
                continue;
            }
            if (codePoint <= 2047) {
                buffer[0] = 37;
                buffer[3] = 37;
                buffer[5] = HEX_CHARACTERS[codePoint & 0xF];
                buffer[4] = HEX_CHARACTERS[8 | (codePoint >>>= 4) & 3];
                buffer[2] = HEX_CHARACTERS[(codePoint >>>= 2) & 0xF];
                buffer[1] = HEX_CHARACTERS[(codePoint >>>= 4) | 0xC];
                escapedBuilder.append(buffer, 0, 6);
                continue;
            }
            if (codePoint <= 65535) {
                buffer[0] = 37;
                buffer[1] = 69;
                buffer[3] = 37;
                buffer[6] = 37;
                buffer[8] = HEX_CHARACTERS[codePoint & 0xF];
                buffer[7] = HEX_CHARACTERS[8 | (codePoint >>>= 4) & 3];
                buffer[5] = HEX_CHARACTERS[(codePoint >>>= 2) & 0xF];
                buffer[4] = HEX_CHARACTERS[8 | (codePoint >>>= 4) & 3];
                buffer[2] = HEX_CHARACTERS[(codePoint >>>= 2) & 0xF];
                escapedBuilder.append(buffer, 0, 9);
                continue;
            }
            if (codePoint > 0x10FFFF) continue;
            buffer[0] = 37;
            buffer[1] = 70;
            buffer[3] = 37;
            buffer[6] = 37;
            buffer[9] = 37;
            buffer[11] = HEX_CHARACTERS[codePoint & 0xF];
            buffer[10] = HEX_CHARACTERS[8 | (codePoint >>>= 4) & 3];
            buffer[8] = HEX_CHARACTERS[(codePoint >>>= 2) & 0xF];
            buffer[7] = HEX_CHARACTERS[8 | (codePoint >>>= 4) & 3];
            buffer[5] = HEX_CHARACTERS[(codePoint >>>= 2) & 0xF];
            buffer[4] = HEX_CHARACTERS[8 | (codePoint >>>= 4) & 3];
            buffer[2] = HEX_CHARACTERS[(codePoint >>>= 2) & 7];
            escapedBuilder.append(buffer);
        }
        if (escapedBuilder == null) {
            return original;
        }
        if (last < end) {
            escapedBuilder.append(original, last, end);
        }
        return escapedBuilder.toString();
    }

    private static int getCodePoint(String original, int index, int end) {
        char char1;
        if (!Character.isSurrogate(char1 = original.charAt(index++))) {
            return char1;
        }
        if (Character.isHighSurrogate(char1)) {
            if (index == end) {
                throw LOGGER.logThrowableAsError(new IllegalStateException("String contains trailing high surrogate without paired low surrogate."));
            }
            char char2 = original.charAt(index);
            if (Character.isLowSurrogate(char2)) {
                return Character.toCodePoint(char1, char2);
            }
            throw LOGGER.logThrowableAsError(new IllegalStateException("String contains high surrogate without trailing low surrogate."));
        }
        throw LOGGER.logThrowableAsError(new IllegalStateException("String contains low surrogate without leading high surrogate."));
    }

    static {
        Arrays.fill(SAFE_CHARACTERS, 97, 123, true);
        Arrays.fill(SAFE_CHARACTERS, 65, 91, true);
        Arrays.fill(SAFE_CHARACTERS, 48, 58, true);
        LOGGER = new ClientLogger(PercentEscaper.class);
    }
}

