/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.otel.tracing;

import io.clientcore.core.implementation.ReflectionUtils;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.implementation.instrumentation.SdkInstrumentationOptionsAccessHelper;
import io.clientcore.core.implementation.instrumentation.otel.FallbackInvoker;
import io.clientcore.core.implementation.instrumentation.otel.OTelAttributeKey;
import io.clientcore.core.implementation.instrumentation.otel.OTelAttributes;
import io.clientcore.core.implementation.instrumentation.otel.OTelContext;
import io.clientcore.core.implementation.instrumentation.otel.OTelInitializer;
import io.clientcore.core.implementation.instrumentation.otel.tracing.OTelSpan;
import io.clientcore.core.instrumentation.InstrumentationAttributes;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.SdkInstrumentationOptions;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.tracing.Span;
import io.clientcore.core.instrumentation.tracing.SpanBuilder;
import io.clientcore.core.instrumentation.tracing.SpanKind;

public class OTelSpanBuilder
implements SpanBuilder {
    static final OTelSpanBuilder NOOP = new OTelSpanBuilder(null, SpanKind.INTERNAL, null, new SdkInstrumentationOptions("noop"));
    private static final ClientLogger LOGGER = new ClientLogger(OTelSpanBuilder.class);
    private static final FallbackInvoker SET_PARENT_INVOKER;
    private static final FallbackInvoker SET_ATTRIBUTE_INVOKER;
    private static final FallbackInvoker SET_SPAN_KIND_INVOKER;
    private static final FallbackInvoker START_SPAN_INVOKER;
    private static final FallbackInvoker SET_ALL_ATTRIBUTES_INVOKER;
    private static final Object INTERNAL_KIND;
    private static final Object SERVER_KIND;
    private static final Object CLIENT_KIND;
    private static final Object PRODUCER_KIND;
    private static final Object CONSUMER_KIND;
    private final Object otelSpanBuilder;
    private final boolean suppressNestedSpans;
    private final SpanKind spanKind;
    private final InstrumentationContext context;

    OTelSpanBuilder(Object otelSpanBuilder, SpanKind kind, InstrumentationContext parent, SdkInstrumentationOptions sdkOptions) {
        this.otelSpanBuilder = otelSpanBuilder;
        this.suppressNestedSpans = sdkOptions == null || !SdkInstrumentationOptionsAccessHelper.isSpanSuppressionDisabled(sdkOptions);
        this.spanKind = kind;
        this.context = parent;
    }

    @Override
    public SpanBuilder setAttribute(String key, Object value) {
        Object otelKey;
        if (this.isInitialized() && (otelKey = OTelAttributeKey.getKey(key, value)) != null) {
            SET_ATTRIBUTE_INVOKER.invoke(this.otelSpanBuilder, otelKey, OTelAttributeKey.castAttributeValue(value));
        }
        return this;
    }

    @Override
    public SpanBuilder setAllAttributes(InstrumentationAttributes attributes) {
        Object otelAttributes;
        if (this.isInitialized() && attributes instanceof OTelAttributes && (otelAttributes = ((OTelAttributes)attributes).getOTelAttributes()) != null) {
            SET_ALL_ATTRIBUTES_INVOKER.invoke(this.otelSpanBuilder, otelAttributes);
        }
        return this;
    }

    @Override
    public Span startSpan() {
        if (this.isInitialized()) {
            Object otelSpan;
            SpanKind parentKind;
            Object otelParentContext = OTelContext.fromInstrumentationContext(this.context);
            OTelSpan parentSpan = OTelContext.getClientCoreSpan(otelParentContext);
            SpanKind spanKind = parentKind = parentSpan == null ? null : parentSpan.getSpanKind();
            if (this.suppressNestedSpans && parentKind == this.spanKind) {
                otelSpan = OTelSpan.createPropagatingSpan(otelParentContext);
            } else {
                SET_PARENT_INVOKER.invoke(this.otelSpanBuilder, otelParentContext);
                SET_SPAN_KIND_INVOKER.invoke(this.otelSpanBuilder, this.toOtelSpanKind(this.spanKind));
                otelSpan = START_SPAN_INVOKER.invoke(this.otelSpanBuilder);
            }
            if (otelSpan != null) {
                return new OTelSpan(otelSpan, otelParentContext, this.spanKind);
            }
        }
        return OTelSpan.NOOP_SPAN;
    }

    private Object toOtelSpanKind(SpanKind spanKind) {
        switch (spanKind) {
            case SERVER: {
                return SERVER_KIND;
            }
            case CLIENT: {
                return CLIENT_KIND;
            }
            case PRODUCER: {
                return PRODUCER_KIND;
            }
            case CONSUMER: {
                return CONSUMER_KIND;
            }
        }
        return INTERNAL_KIND;
    }

    private boolean isInitialized() {
        return this.otelSpanBuilder != null && OTelInitializer.isInitialized();
    }

    static {
        ReflectiveInvoker setParentInvoker = null;
        ReflectiveInvoker setAttributeInvoker = null;
        ReflectiveInvoker setSpanKindInvoker = null;
        ReflectiveInvoker startSpanInvoker = null;
        ReflectiveInvoker setAllAttributesInvoker = null;
        Object internalKind = null;
        Object serverKind = null;
        Object clientKind = null;
        Object producerKind = null;
        Object consumerKind = null;
        if (OTelInitializer.isInitialized()) {
            try {
                setParentInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_BUILDER_CLASS, OTelInitializer.SPAN_BUILDER_CLASS.getMethod("setParent", OTelInitializer.CONTEXT_CLASS));
                setAttributeInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_BUILDER_CLASS, OTelInitializer.SPAN_BUILDER_CLASS.getMethod("setAttribute", OTelInitializer.ATTRIBUTE_KEY_CLASS, Object.class));
                setSpanKindInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_BUILDER_CLASS, OTelInitializer.SPAN_BUILDER_CLASS.getMethod("setSpanKind", OTelInitializer.SPAN_KIND_CLASS));
                startSpanInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_BUILDER_CLASS, OTelInitializer.SPAN_BUILDER_CLASS.getMethod("startSpan", new Class[0]));
                setAllAttributesInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_BUILDER_CLASS, OTelInitializer.SPAN_BUILDER_CLASS.getMethod("setAllAttributes", OTelInitializer.ATTRIBUTES_CLASS));
                internalKind = OTelInitializer.SPAN_KIND_CLASS.getField("INTERNAL").get(null);
                serverKind = OTelInitializer.SPAN_KIND_CLASS.getField("SERVER").get(null);
                clientKind = OTelInitializer.SPAN_KIND_CLASS.getField("CLIENT").get(null);
                producerKind = OTelInitializer.SPAN_KIND_CLASS.getField("PRODUCER").get(null);
                consumerKind = OTelInitializer.SPAN_KIND_CLASS.getField("CONSUMER").get(null);
            }
            catch (Throwable t) {
                OTelInitializer.initError(LOGGER, t);
            }
        }
        SET_PARENT_INVOKER = new FallbackInvoker(setParentInvoker, LOGGER);
        SET_ATTRIBUTE_INVOKER = new FallbackInvoker(setAttributeInvoker, LOGGER);
        SET_SPAN_KIND_INVOKER = new FallbackInvoker(setSpanKindInvoker, LOGGER);
        START_SPAN_INVOKER = new FallbackInvoker(startSpanInvoker, OTelSpan.NOOP_SPAN.getOtelSpan(), LOGGER);
        SET_ALL_ATTRIBUTES_INVOKER = new FallbackInvoker(setAllAttributesInvoker, LOGGER);
        INTERNAL_KIND = internalKind;
        SERVER_KIND = serverKind;
        CLIENT_KIND = clientKind;
        PRODUCER_KIND = producerKind;
        CONSUMER_KIND = consumerKind;
    }
}

