/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.otel.metrics;

import io.clientcore.core.implementation.ReflectionUtils;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.implementation.instrumentation.NoopMeter;
import io.clientcore.core.implementation.instrumentation.otel.FallbackInvoker;
import io.clientcore.core.implementation.instrumentation.otel.OTelInitializer;
import io.clientcore.core.implementation.instrumentation.otel.metrics.OTelDoubleHistogram;
import io.clientcore.core.implementation.instrumentation.otel.metrics.OTelLongCounter;
import io.clientcore.core.implementation.instrumentation.otel.metrics.OTelLongUpDownCounter;
import io.clientcore.core.instrumentation.SdkInstrumentationOptions;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.metrics.DoubleHistogram;
import io.clientcore.core.instrumentation.metrics.LongCounter;
import io.clientcore.core.instrumentation.metrics.Meter;
import java.util.List;
import java.util.Objects;

public class OTelMeter
implements Meter {
    private static final ClientLogger LOGGER = new ClientLogger(OTelMeter.class);
    private static final FallbackInvoker SET_INSTRUMENTATION_VERSION_INVOKER;
    private static final FallbackInvoker BUILD_INVOKER;
    private static final FallbackInvoker SET_SCHEMA_URL_INVOKER;
    private static final FallbackInvoker GET_METER_BUILDER_INVOKER;
    private final Object otelMeter;

    public OTelMeter(Object otelMeterProvider, SdkInstrumentationOptions sdkOptions) {
        Object meterBuilder = GET_METER_BUILDER_INVOKER.invoke(otelMeterProvider, sdkOptions.getSdkName());
        if (meterBuilder != null) {
            SET_INSTRUMENTATION_VERSION_INVOKER.invoke(meterBuilder, sdkOptions.getSdkVersion());
            SET_SCHEMA_URL_INVOKER.invoke(meterBuilder, sdkOptions.getSchemaUrl());
            this.otelMeter = BUILD_INVOKER.invoke(meterBuilder);
        } else {
            this.otelMeter = null;
        }
    }

    @Override
    public DoubleHistogram createDoubleHistogram(String name, String description, String unit, List<Double> bucketBoundaries) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Objects.requireNonNull(description, "'description' cannot be null.");
        Objects.requireNonNull(unit, "'unit' cannot be null.");
        return OTelDoubleHistogram.create(this.otelMeter, name, description, unit, bucketBoundaries);
    }

    @Override
    public LongCounter createLongCounter(String name, String description, String unit) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Objects.requireNonNull(description, "'description' cannot be null.");
        Objects.requireNonNull(unit, "'unit' cannot be null.");
        return OTelLongCounter.create(this.otelMeter, name, description, unit);
    }

    @Override
    public LongCounter createLongUpDownCounter(String name, String description, String unit) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Objects.requireNonNull(description, "'description' cannot be null.");
        Objects.requireNonNull(unit, "'unit' cannot be null.");
        return OTelLongUpDownCounter.create(this.otelMeter, name, description, unit);
    }

    @Override
    public boolean isEnabled() {
        return this.otelMeter != null && OTelInitializer.isInitialized();
    }

    static {
        ReflectiveInvoker setInstrumentationVersionInvoker = null;
        ReflectiveInvoker buildInvoker = null;
        ReflectiveInvoker setSchemaUrlInvoker = null;
        ReflectiveInvoker getMeterBuilderInvoker = null;
        if (OTelInitializer.isInitialized()) {
            try {
                setInstrumentationVersionInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.METER_BUILDER_CLASS, OTelInitializer.METER_BUILDER_CLASS.getMethod("setInstrumentationVersion", String.class));
                setSchemaUrlInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.METER_BUILDER_CLASS, OTelInitializer.METER_BUILDER_CLASS.getMethod("setSchemaUrl", String.class));
                buildInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.METER_BUILDER_CLASS, OTelInitializer.METER_BUILDER_CLASS.getMethod("build", new Class[0]));
                getMeterBuilderInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.METER_PROVIDER_CLASS, OTelInitializer.METER_PROVIDER_CLASS.getMethod("meterBuilder", String.class));
            }
            catch (Throwable t) {
                OTelInitializer.initError(LOGGER, t);
            }
        }
        SET_INSTRUMENTATION_VERSION_INVOKER = new FallbackInvoker(setInstrumentationVersionInvoker, LOGGER);
        SET_SCHEMA_URL_INVOKER = new FallbackInvoker(setSchemaUrlInvoker, LOGGER);
        BUILD_INVOKER = new FallbackInvoker(buildInvoker, NoopMeter.INSTANCE, LOGGER);
        GET_METER_BUILDER_INVOKER = new FallbackInvoker(getMeterBuilderInvoker, LOGGER);
    }
}

