/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.otel;

import io.clientcore.core.implementation.ReflectionUtils;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.implementation.instrumentation.NoopAttributes;
import io.clientcore.core.implementation.instrumentation.otel.FallbackInvoker;
import io.clientcore.core.implementation.instrumentation.otel.OTelAttributeKey;
import io.clientcore.core.implementation.instrumentation.otel.OTelInitializer;
import io.clientcore.core.instrumentation.InstrumentationAttributes;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.util.Map;
import java.util.Objects;

public final class OTelAttributes
implements InstrumentationAttributes {
    private static final ClientLogger LOGGER = new ClientLogger(OTelAttributes.class);
    private static final FallbackInvoker ATTRIBUTES_BUILDER_INVOKER;
    private static final FallbackInvoker PUT_INVOKER;
    private static final FallbackInvoker BUILD_INVOKER;
    private static final FallbackInvoker TO_BUILD_INVOKER;
    private static final OTelAttributes EMPTY_INSTANCE;
    private final Object otelAttributes;

    public static InstrumentationAttributes create(Map<String, Object> attributes) {
        if (attributes == null) {
            return EMPTY_INSTANCE;
        }
        Object attributesBuilder = ATTRIBUTES_BUILDER_INVOKER.invoke();
        if (attributesBuilder == null) {
            return NoopAttributes.INSTANCE;
        }
        for (Map.Entry<String, Object> kvp : attributes.entrySet()) {
            String key = kvp.getKey();
            Object value = kvp.getValue();
            Objects.requireNonNull(key, "attribute key cannot be null.");
            Objects.requireNonNull(value, "attribute value cannot be null.");
            Object otelKey = OTelAttributeKey.getKey(key, value);
            PUT_INVOKER.invoke(attributesBuilder, otelKey, OTelAttributeKey.castAttributeValue(value));
        }
        return new OTelAttributes(BUILD_INVOKER.invoke(attributesBuilder));
    }

    private OTelAttributes(Object otelAttributes) {
        this.otelAttributes = otelAttributes;
    }

    public Object getOTelAttributes() {
        return this.otelAttributes;
    }

    @Override
    public InstrumentationAttributes put(String key, Object value) {
        Objects.requireNonNull(key, "'key' cannot be null.");
        Objects.requireNonNull(value, "'value' cannot be null.");
        if (this.isEnabled()) {
            Object attributesBuilder = TO_BUILD_INVOKER.invoke(this.otelAttributes);
            if (attributesBuilder == null) {
                return NoopAttributes.INSTANCE;
            }
            Object otelKey = OTelAttributeKey.getKey(key, value);
            if (otelKey != null) {
                PUT_INVOKER.invoke(attributesBuilder, otelKey, OTelAttributeKey.castAttributeValue(value));
            }
            return new OTelAttributes(BUILD_INVOKER.invoke(attributesBuilder));
        }
        return NoopAttributes.INSTANCE;
    }

    private boolean isEnabled() {
        return this.otelAttributes != null && OTelInitializer.isInitialized();
    }

    static {
        ReflectiveInvoker attributesBuilderInvoker = null;
        ReflectiveInvoker putInvoker = null;
        ReflectiveInvoker buildInvoker = null;
        ReflectiveInvoker toBuildInvoker = null;
        Object emptyInstance = null;
        try {
            attributesBuilderInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.ATTRIBUTES_CLASS, OTelInitializer.ATTRIBUTES_CLASS.getMethod("builder", new Class[0]));
            putInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.ATTRIBUTES_BUILDER_CLASS, OTelInitializer.ATTRIBUTES_BUILDER_CLASS.getMethod("put", OTelInitializer.ATTRIBUTE_KEY_CLASS, Object.class));
            buildInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.ATTRIBUTES_BUILDER_CLASS, OTelInitializer.ATTRIBUTES_BUILDER_CLASS.getMethod("build", new Class[0]));
            toBuildInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.ATTRIBUTES_CLASS, OTelInitializer.ATTRIBUTES_CLASS.getMethod("toBuilder", new Class[0]));
            ReflectiveInvoker emptyInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.ATTRIBUTES_CLASS, OTelInitializer.ATTRIBUTES_CLASS.getMethod("empty", new Class[0]));
            emptyInstance = emptyInvoker.invoke();
        }
        catch (Throwable t) {
            OTelInitializer.initError(LOGGER, t);
        }
        ATTRIBUTES_BUILDER_INVOKER = new FallbackInvoker(attributesBuilderInvoker, LOGGER);
        PUT_INVOKER = new FallbackInvoker(putInvoker, LOGGER);
        BUILD_INVOKER = new FallbackInvoker(buildInvoker, LOGGER);
        TO_BUILD_INVOKER = new FallbackInvoker(toBuildInvoker, LOGGER);
        EMPTY_INSTANCE = new OTelAttributes(emptyInstance);
    }
}

