/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.fallback;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

class RandomIdUtils {
    public static final String INVALID_TRACE_ID = "00000000000000000000000000000000";
    public static final String INVALID_SPAN_ID = "0000000000000000";
    private static final int BYTE_BASE16 = 2;
    private static final long INVALID_ID = 0L;
    private static final int TRACE_ID_HEX_LENGTH = 32;
    private static final int SPAN_ID_HEX_LENGTH = 16;
    private static final char[] ENCODING = RandomIdUtils.buildEncodingArray();

    RandomIdUtils() {
    }

    public static String generateSpanId() {
        long id;
        while ((id = ThreadLocalRandom.current().nextLong()) == 0L) {
        }
        return RandomIdUtils.getSpanId(id);
    }

    public static String generateTraceId() {
        long idLo;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long idHi = ((Random)random).nextLong();
        while ((idLo = ((Random)random).nextLong()) == 0L) {
        }
        return RandomIdUtils.getTraceId(idHi, idLo);
    }

    private static String getSpanId(long id) {
        if (id == 0L) {
            return INVALID_SPAN_ID;
        }
        char[] result = new char[16];
        RandomIdUtils.longToBase16String(id, result, 0);
        return new String(result, 0, 16);
    }

    private static String getTraceId(long traceIdLongHighPart, long traceIdLongLowPart) {
        if (traceIdLongHighPart == 0L && traceIdLongLowPart == 0L) {
            return INVALID_TRACE_ID;
        }
        char[] chars = new char[32];
        RandomIdUtils.longToBase16String(traceIdLongHighPart, chars, 0);
        RandomIdUtils.longToBase16String(traceIdLongLowPart, chars, 16);
        return new String(chars, 0, 32);
    }

    private static void longToBase16String(long value, char[] dest, int destOffset) {
        RandomIdUtils.byteToBase16((byte)(value >> 56 & 0xFFL), dest, destOffset);
        RandomIdUtils.byteToBase16((byte)(value >> 48 & 0xFFL), dest, destOffset + 2);
        RandomIdUtils.byteToBase16((byte)(value >> 40 & 0xFFL), dest, destOffset + 4);
        RandomIdUtils.byteToBase16((byte)(value >> 32 & 0xFFL), dest, destOffset + 6);
        RandomIdUtils.byteToBase16((byte)(value >> 24 & 0xFFL), dest, destOffset + 8);
        RandomIdUtils.byteToBase16((byte)(value >> 16 & 0xFFL), dest, destOffset + 10);
        RandomIdUtils.byteToBase16((byte)(value >> 8 & 0xFFL), dest, destOffset + 12);
        RandomIdUtils.byteToBase16((byte)(value & 0xFFL), dest, destOffset + 14);
    }

    private static void byteToBase16(byte value, char[] dest, int destOffset) {
        int b = value & 0xFF;
        dest[destOffset] = ENCODING[b];
        dest[destOffset + 1] = ENCODING[b | 0x100];
    }

    private static char[] buildEncodingArray() {
        String alphabet = "0123456789abcdef";
        char[] encoding = new char[512];
        for (int i = 0; i < 256; ++i) {
            encoding[i] = alphabet.charAt(i >>> 4);
            encoding[i | 0x100] = alphabet.charAt(i & 0xF);
        }
        return encoding;
    }
}

