/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.fallback;

import io.clientcore.core.implementation.instrumentation.fallback.FallbackSpanBuilder;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.InstrumentationOptions;
import io.clientcore.core.instrumentation.SdkInstrumentationOptions;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.tracing.SpanBuilder;
import io.clientcore.core.instrumentation.tracing.SpanKind;
import io.clientcore.core.instrumentation.tracing.Tracer;
import java.util.HashMap;

final class FallbackTracer
implements Tracer {
    private static final ClientLogger LOGGER = new ClientLogger(FallbackTracer.class);
    private final boolean isEnabled;
    private final ClientLogger logger;

    FallbackTracer(InstrumentationOptions instrumentationOptions, SdkInstrumentationOptions sdkOptions) {
        this.isEnabled = instrumentationOptions == null || instrumentationOptions.isTracingEnabled();
        this.logger = this.isEnabled ? FallbackTracer.getLogger(instrumentationOptions, sdkOptions) : LOGGER;
    }

    private static ClientLogger getLogger(InstrumentationOptions instrumentationOptions, SdkInstrumentationOptions sdkOptions) {
        Object providedLogger;
        Object object = providedLogger = instrumentationOptions == null ? null : instrumentationOptions.getTelemetryProvider();
        if (providedLogger instanceof ClientLogger) {
            return (ClientLogger)providedLogger;
        }
        HashMap<String, Object> libraryContext = new HashMap<String, Object>(2);
        libraryContext.put("sdk.name", sdkOptions.getSdkName());
        libraryContext.put("sdk.version", sdkOptions.getSdkVersion());
        return new ClientLogger(sdkOptions.getSdkName() + ".tracing", libraryContext);
    }

    @Override
    public SpanBuilder spanBuilder(String spanName, SpanKind spanKind, InstrumentationContext instrumentationContext) {
        return this.isEnabled ? new FallbackSpanBuilder(this.logger, spanName, spanKind, instrumentationContext) : FallbackSpanBuilder.NOOP;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }
}

