/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.fallback;

import io.clientcore.core.instrumentation.InstrumentationAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class FallbackAttributes
implements InstrumentationAttributes {
    private final Map<String, Object> attributes;

    FallbackAttributes(Map<String, Object> attributes) {
        if (attributes == null) {
            this.attributes = Collections.emptyMap();
            return;
        }
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            Objects.requireNonNull(entry.getKey(), "attribute key cannot be null.");
            Objects.requireNonNull(entry.getValue(), "attribute value cannot be null.");
        }
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    @Override
    public InstrumentationAttributes put(String key, Object value) {
        Objects.requireNonNull(key, "'key' cannot be null.");
        Objects.requireNonNull(value, "'value' cannot be null.");
        HashMap<String, Object> newAttributes = new HashMap<String, Object>((int)((double)(this.attributes.size() + 1) * 1.5));
        newAttributes.putAll(this.attributes);
        newAttributes.put(key, value);
        return new FallbackAttributes(newAttributes);
    }

    Map<String, Object> getAttributes() {
        return this.attributes;
    }
}

