/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation;

import io.clientcore.core.implementation.ReflectionUtils;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.implementation.instrumentation.DefaultLogger;
import io.clientcore.core.instrumentation.logging.LogLevel;

public class Slf4jLoggerShim {
    private static final DefaultLogger DEFAULT_LOGGER;
    private static final ReflectiveInvoker LOGGER_FACTORY_GET_LOGGER;
    private static final ReflectiveInvoker LOGGER_VERBOSE;
    private static final ReflectiveInvoker LOGGER_INFO;
    private static final ReflectiveInvoker LOGGER_WARN;
    private static final ReflectiveInvoker LOGGER_ERROR;
    private static final ReflectiveInvoker LOGGER_IS_VERBOSE_ENABLED;
    private static final ReflectiveInvoker LOGGER_IS_INFO_ENABLED;
    private static final ReflectiveInvoker LOGGER_IS_WARN_ENABLED;
    private static final ReflectiveInvoker LOGGER_IS_ERROR_ENABLED;
    private static final Class<?> NOP_LOGGER_CLASS;
    private static boolean slf4jErrorLogged;
    private final DefaultLogger defaultLogger;
    private volatile Object slf4jLogger;
    private boolean isVerboseEnabled;
    private boolean isInfoEnabled;
    private boolean isWarnEnabled;
    private boolean isErrorEnabled;
    private final boolean isVerboseEnabledForDefault;
    private final boolean isInfoEnabledForDefault;
    private final boolean isWarnEnabledForDefault;
    private final boolean isErrorEnabledForDefault;

    public Slf4jLoggerShim(DefaultLogger defaultLogger) {
        this(null, defaultLogger);
    }

    public Slf4jLoggerShim(String className) {
        this(className, new DefaultLogger(className));
    }

    public Slf4jLoggerShim(Class<?> clazz) {
        this(clazz.getName(), new DefaultLogger(clazz));
    }

    private Slf4jLoggerShim(String className, DefaultLogger defaultLogger) {
        Object localSlf4jLogger;
        this.slf4jLogger = localSlf4jLogger = Slf4jLoggerShim.createLogger(className);
        this.defaultLogger = defaultLogger;
        if (localSlf4jLogger != null) {
            try {
                this.isVerboseEnabled = (Boolean)LOGGER_IS_VERBOSE_ENABLED.invokeWithArguments(localSlf4jLogger, new Object[0]);
                this.isInfoEnabled = (Boolean)LOGGER_IS_INFO_ENABLED.invokeWithArguments(localSlf4jLogger, new Object[0]);
                this.isWarnEnabled = (Boolean)LOGGER_IS_WARN_ENABLED.invokeWithArguments(localSlf4jLogger, new Object[0]);
                this.isErrorEnabled = (Boolean)LOGGER_IS_ERROR_ENABLED.invokeWithArguments(localSlf4jLogger, new Object[0]);
            }
            catch (Throwable e) {
                Slf4jLoggerShim.writeSlf4jDisabledError(LogLevel.VERBOSE, "Failed to check if SLF4J log level is enabled", e);
                this.slf4jLogger = null;
            }
        }
        this.isVerboseEnabledForDefault = defaultLogger.isEnabled(LogLevel.VERBOSE);
        this.isInfoEnabledForDefault = defaultLogger.isEnabled(LogLevel.INFORMATIONAL);
        this.isWarnEnabledForDefault = defaultLogger.isEnabled(LogLevel.WARNING);
        this.isErrorEnabledForDefault = defaultLogger.isEnabled(LogLevel.ERROR);
    }

    public boolean canLogAtLevel(LogLevel logLevel) {
        if (logLevel == null) {
            return false;
        }
        boolean slf4jLoggerAvailable = this.slf4jLogger != null;
        switch (logLevel) {
            case VERBOSE: {
                return slf4jLoggerAvailable && this.isVerboseEnabled || !slf4jLoggerAvailable && this.isVerboseEnabledForDefault;
            }
            case INFORMATIONAL: {
                return slf4jLoggerAvailable && this.isInfoEnabled || !slf4jLoggerAvailable && this.isInfoEnabledForDefault;
            }
            case WARNING: {
                return slf4jLoggerAvailable && this.isWarnEnabled || !slf4jLoggerAvailable && this.isWarnEnabledForDefault;
            }
            case ERROR: {
                return slf4jLoggerAvailable && this.isErrorEnabled || !slf4jLoggerAvailable && this.isErrorEnabledForDefault;
            }
        }
        return false;
    }

    public void performLogging(LogLevel logLevel, String message, Throwable throwable) {
        if (!this.canLogAtLevel(logLevel)) {
            return;
        }
        Object localSlf4jLogger = this.slf4jLogger;
        if (localSlf4jLogger != null) {
            try {
                switch (logLevel) {
                    case VERBOSE: {
                        LOGGER_VERBOSE.invoke(localSlf4jLogger, message, throwable);
                        break;
                    }
                    case INFORMATIONAL: {
                        LOGGER_INFO.invoke(localSlf4jLogger, message, throwable);
                        break;
                    }
                    case WARNING: {
                        LOGGER_WARN.invoke(localSlf4jLogger, message, throwable);
                        break;
                    }
                    case ERROR: {
                        LOGGER_ERROR.invoke(localSlf4jLogger, message, throwable);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                Slf4jLoggerShim.writeSlf4jDisabledError(LogLevel.VERBOSE, "Failed to log message with SLF4J", e);
                this.slf4jLogger = null;
                this.defaultLogger.log(logLevel, message, null);
            }
        } else {
            this.defaultLogger.log(logLevel, message, null);
        }
    }

    static Object createLogger(String className) {
        if (LOGGER_FACTORY_GET_LOGGER == null || NOP_LOGGER_CLASS == null) {
            return null;
        }
        try {
            Object logger = LOGGER_FACTORY_GET_LOGGER.invokeStatic(className);
            if (NOP_LOGGER_CLASS.isAssignableFrom(logger.getClass())) {
                Slf4jLoggerShim.writeSlf4jDisabledError(LogLevel.VERBOSE, "Resolved NOPLogger", null);
                return null;
            }
            return logger;
        }
        catch (Throwable e) {
            Slf4jLoggerShim.writeSlf4jDisabledError(LogLevel.WARNING, "Failed to create SLF4J logger", e);
            return null;
        }
    }

    private static void writeSlf4jDisabledError(LogLevel level, String message, Throwable throwable) {
        if (!slf4jErrorLogged) {
            slf4jErrorLogged = true;
            DEFAULT_LOGGER.log(level, String.format("[DefaultLogger]: %s. SLF4J logging will be disabled.", message), throwable);
        }
    }

    static {
        ReflectiveInvoker isErrorEnabledMethodHandle;
        ReflectiveInvoker isWarnEnabledMethodHandle;
        ReflectiveInvoker isInfoEnabledMethodHandle;
        ReflectiveInvoker isVerboseEnabledMethodHandle;
        ReflectiveInvoker logErrorMethodHandle;
        ReflectiveInvoker logWarnMethodHandle;
        ReflectiveInvoker logInfoMethodHandle;
        ReflectiveInvoker logVerboseMethodHandle;
        ReflectiveInvoker getLoggerMethodHandle;
        Class<?> nopLoggerClass;
        DEFAULT_LOGGER = new DefaultLogger(Slf4jLoggerShim.class);
        slf4jErrorLogged = false;
        try {
            nopLoggerClass = Class.forName("org.slf4j.helpers.NOPLogger", true, Slf4jLoggerShim.class.getClassLoader());
            Class<?> loggerFactoryClass = Class.forName("org.slf4j.LoggerFactory", true, Slf4jLoggerShim.class.getClassLoader());
            Class<?> loggerClass = Class.forName("org.slf4j.Logger", true, Slf4jLoggerShim.class.getClassLoader());
            getLoggerMethodHandle = ReflectionUtils.getMethodInvoker(loggerFactoryClass, loggerFactoryClass.getMethod("getLogger", String.class));
            logVerboseMethodHandle = ReflectionUtils.getMethodInvoker(loggerClass, loggerClass.getMethod("debug", String.class, Throwable.class));
            logInfoMethodHandle = ReflectionUtils.getMethodInvoker(loggerClass, loggerClass.getMethod("info", String.class, Throwable.class));
            logWarnMethodHandle = ReflectionUtils.getMethodInvoker(loggerClass, loggerClass.getMethod("warn", String.class, Throwable.class));
            logErrorMethodHandle = ReflectionUtils.getMethodInvoker(loggerClass, loggerClass.getMethod("error", String.class, Throwable.class));
            isVerboseEnabledMethodHandle = ReflectionUtils.getMethodInvoker(loggerClass, loggerClass.getMethod("isDebugEnabled", new Class[0]));
            isInfoEnabledMethodHandle = ReflectionUtils.getMethodInvoker(loggerClass, loggerClass.getMethod("isInfoEnabled", new Class[0]));
            isWarnEnabledMethodHandle = ReflectionUtils.getMethodInvoker(loggerClass, loggerClass.getMethod("isWarnEnabled", new Class[0]));
            isErrorEnabledMethodHandle = ReflectionUtils.getMethodInvoker(loggerClass, loggerClass.getMethod("isErrorEnabled", new Class[0]));
        }
        catch (Exception e) {
            DEFAULT_LOGGER.log(LogLevel.VERBOSE, "Failed to initialize Slf4jLoggerShim.", e);
            nopLoggerClass = null;
            getLoggerMethodHandle = null;
            logVerboseMethodHandle = null;
            logInfoMethodHandle = null;
            logWarnMethodHandle = null;
            logErrorMethodHandle = null;
            isVerboseEnabledMethodHandle = null;
            isInfoEnabledMethodHandle = null;
            isWarnEnabledMethodHandle = null;
            isErrorEnabledMethodHandle = null;
        }
        LOGGER_FACTORY_GET_LOGGER = getLoggerMethodHandle;
        NOP_LOGGER_CLASS = nopLoggerClass;
        LOGGER_VERBOSE = logVerboseMethodHandle;
        LOGGER_INFO = logInfoMethodHandle;
        LOGGER_WARN = logWarnMethodHandle;
        LOGGER_ERROR = logErrorMethodHandle;
        LOGGER_IS_VERBOSE_ENABLED = isVerboseEnabledMethodHandle;
        LOGGER_IS_INFO_ENABLED = isInfoEnabledMethodHandle;
        LOGGER_IS_WARN_ENABLED = isWarnEnabledMethodHandle;
        LOGGER_IS_ERROR_ENABLED = isErrorEnabledMethodHandle;
    }
}

