/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation;

import io.clientcore.core.instrumentation.logging.LogLevel;
import io.clientcore.core.utils.configuration.Configuration;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;

public final class DefaultLogger {
    private static final String WHITESPACE = " ";
    private static final String HYPHEN = " - ";
    private static final String OPEN_BRACKET = " [";
    private static final String CLOSE_BRACKET = "]";
    private static final String WARN = "WARN";
    private static final String DEBUG = "DEBUG";
    private static final String INFO = "INFO";
    private static final String ERROR = "ERROR";
    private static final String NOTSET = "NOTSET";
    private final String classPath;
    private final LogLevel level;
    private final PrintStream logLocation;

    public DefaultLogger(Class<?> clazz) {
        this(clazz.getCanonicalName(), System.out, DefaultLogger.fromEnvironment());
    }

    public DefaultLogger(String className) {
        this(className, System.out, DefaultLogger.fromEnvironment());
    }

    public DefaultLogger(String className, PrintStream logLocation, LogLevel logLevel) {
        this.classPath = className;
        this.logLocation = logLocation;
        this.level = logLevel;
    }

    public boolean isEnabled(LogLevel level) {
        if (this.level == LogLevel.NOTSET) {
            return false;
        }
        return level.compareTo(this.level) >= 0;
    }

    public void log(LogLevel level, String message, Throwable throwable) {
        if (!this.isEnabled(level)) {
            return;
        }
        String dateTime = DefaultLogger.getFormattedDate();
        String threadName = Thread.currentThread().getName();
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(dateTime).append(OPEN_BRACKET).append(threadName).append(CLOSE_BRACKET).append(OPEN_BRACKET).append(DefaultLogger.getLevelName(level)).append(CLOSE_BRACKET).append(WHITESPACE).append(this.classPath).append(HYPHEN).append(message).append(System.lineSeparator());
        DefaultLogger.appendThrowable(stringBuilder, throwable);
        this.logLocation.print(stringBuilder);
    }

    private static String getLevelName(LogLevel level) {
        switch (level) {
            case VERBOSE: {
                return DEBUG;
            }
            case INFORMATIONAL: {
                return INFO;
            }
            case WARNING: {
                return WARN;
            }
            case ERROR: {
                return ERROR;
            }
        }
        return NOTSET;
    }

    public static void appendThrowable(StringBuilder stringBuilder, Throwable t) {
        if (t != null) {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                t.printStackTrace(pw);
                stringBuilder.append(sw);
            }
        }
    }

    private static String getFormattedDate() {
        LocalDateTime now = LocalDateTime.now();
        byte[] bytes = new byte[23];
        int year = now.getYear();
        int round = year / 1000;
        bytes[0] = (byte)(48 + round);
        year -= 1000 * round;
        round = year / 100;
        bytes[1] = (byte)(48 + round);
        year -= 100 * round;
        round = year / 10;
        bytes[2] = (byte)(48 + round);
        bytes[3] = (byte)(48 + (year - 10 * round));
        bytes[4] = 45;
        DefaultLogger.zeroPad(now.getMonthValue(), bytes, 5);
        bytes[7] = 45;
        DefaultLogger.zeroPad(now.getDayOfMonth(), bytes, 8);
        bytes[10] = 32;
        DefaultLogger.zeroPad(now.getHour(), bytes, 11);
        bytes[13] = 58;
        DefaultLogger.zeroPad(now.getMinute(), bytes, 14);
        bytes[16] = 58;
        DefaultLogger.zeroPad(now.getSecond(), bytes, 17);
        bytes[19] = 46;
        int millis = now.get(ChronoField.MILLI_OF_SECOND);
        round = millis / 100;
        bytes[20] = (byte)(48 + round);
        millis -= 100 * round;
        round = millis / 10;
        bytes[21] = (byte)(48 + round);
        bytes[22] = (byte)(48 + (millis - 10 * round));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void zeroPad(int value, byte[] bytes, int index) {
        if (value < 10) {
            bytes[index++] = 48;
            bytes[index] = (byte)(48 + value);
        } else {
            int high = value / 10;
            bytes[index++] = (byte)(48 + high);
            bytes[index] = (byte)(48 + (value - 10 * high));
        }
    }

    private static LogLevel fromEnvironment() {
        return LogLevel.fromString(Configuration.getGlobalConfiguration().get("LOG_LEVEL"));
    }
}

