/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.http.rest;

import io.clientcore.core.annotations.ServiceInterface;
import io.clientcore.core.implementation.http.rest.MissingRequiredAnnotationException;
import io.clientcore.core.implementation.http.rest.SwaggerMethodParser;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SwaggerInterfaceParser {
    private static final Map<Class<?>, SwaggerInterfaceParser> INTERFACE_PARSERS = new ConcurrentHashMap();
    private final String host;
    private final String serviceName;
    private final Map<Method, SwaggerMethodParser> methodParsers = new ConcurrentHashMap<Method, SwaggerMethodParser>();

    public static SwaggerInterfaceParser getInstance(Class<?> swaggerInterface) {
        return INTERFACE_PARSERS.computeIfAbsent(swaggerInterface, SwaggerInterfaceParser::new);
    }

    SwaggerInterfaceParser(Class<?> swaggerInterface) {
        ServiceInterface serviceAnnotation = swaggerInterface.getAnnotation(ServiceInterface.class);
        if (serviceAnnotation == null || serviceAnnotation.name().isEmpty()) {
            throw new MissingRequiredAnnotationException(ServiceInterface.class, swaggerInterface);
        }
        this.serviceName = serviceAnnotation.name();
        this.host = serviceAnnotation.host();
    }

    public SwaggerMethodParser getMethodParser(Method swaggerMethod) {
        return this.methodParsers.computeIfAbsent(swaggerMethod, sm -> new SwaggerMethodParser(this, (Method)sm));
    }

    public String getHost() {
        return this.host;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

