/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.http.rest;

import io.clientcore.core.implementation.http.rest.RestProxyImpl;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

final class LengthValidatingInputStream
extends InputStream {
    private static final ClientLogger LOGGER = new ClientLogger(LengthValidatingInputStream.class);
    private final InputStream inner;
    private final long expectedReadSize;
    private long position;
    private long mark = -1L;

    LengthValidatingInputStream(InputStream inputStream, long expectedReadSize) {
        this.inner = Objects.requireNonNull(inputStream, "'inputStream' cannot be null.");
        if (expectedReadSize < 0L) {
            throw LOGGER.logThrowableAsError(new IllegalArgumentException("'expectedReadSize' cannot be less than 0."));
        }
        this.expectedReadSize = expectedReadSize;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int readSize;
        int totalRead = 0;
        do {
            readSize = this.inner.read(b, off + totalRead, len - totalRead);
            this.validateLength(readSize);
            if (readSize != -1) {
                totalRead += readSize;
                continue;
            }
            if (totalRead != 0) continue;
            totalRead = -1;
        } while (readSize != -1 && totalRead != len);
        return totalRead;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        long skipped = this.inner.skip(n);
        this.position += skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.inner.available();
    }

    @Override
    public void close() throws IOException {
        this.inner.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inner.mark(readlimit);
        this.mark = this.position;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inner.reset();
        this.position = this.mark;
    }

    @Override
    public boolean markSupported() {
        return this.inner.markSupported();
    }

    @Override
    public synchronized int read() throws IOException {
        int read = this.inner.read();
        this.validateLength(read == -1 ? -1 : 1);
        return read;
    }

    private void validateLength(int readSize) {
        if (readSize == -1) {
            if (this.position > this.expectedReadSize) {
                throw new IllegalStateException(RestProxyImpl.bodyTooLarge(this.position, this.expectedReadSize));
            }
            if (this.position < this.expectedReadSize) {
                throw new IllegalStateException(RestProxyImpl.bodyTooSmall(this.position, this.expectedReadSize));
            }
        } else {
            this.position += (long)readSize;
        }
    }
}

