/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.http;

import io.clientcore.core.models.CoreException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class RetryUtils {
    private static final int HTTP_STATUS_TOO_MANY_REQUESTS = 429;

    public static boolean isRetryable(int statusCode) {
        return statusCode == 408 || statusCode == 429 || statusCode >= 500 && statusCode != 501 && statusCode != 505;
    }

    public static boolean isRetryable(Throwable e) {
        if (e instanceof CoreException) {
            return ((CoreException)e).isRetryable();
        }
        if (e instanceof UncheckedIOException) {
            return RetryUtils.isRetryable(e.getCause());
        }
        if (e instanceof IOException) {
            return !(e instanceof FileNotFoundException);
        }
        return true;
    }

    private RetryUtils() {
    }
}

