/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation;

import io.clientcore.core.implementation.utils.ImplUtils;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class UrlRedactionUtil {
    private static final String REDACTED_PLACEHOLDER = "REDACTED";

    public static String getRedactedUri(URI uri, Set<String> allowedQueryParameterNames) {
        String query = uri.getQuery();
        int estimatedUriLength = uri.toString().length() + 128;
        StringBuilder uriBuilder = new StringBuilder(estimatedUriLength);
        uriBuilder.append(uri.getScheme()).append("://").append(uri.getHost());
        if (uri.getPort() != -1) {
            uriBuilder.append(":").append(uri.getPort());
        }
        uriBuilder.append(uri.getPath());
        if (query != null && !query.isEmpty()) {
            uriBuilder.append("?");
            boolean firstQueryParam = true;
            for (Map.Entry<String, String> kvp : new ImplUtils.QueryParameterIterable(query)) {
                if (!firstQueryParam) {
                    uriBuilder.append('&');
                }
                uriBuilder.append(kvp.getKey());
                uriBuilder.append('=');
                if (allowedQueryParameterNames.contains(kvp.getKey().toLowerCase(Locale.ROOT))) {
                    uriBuilder.append(kvp.getValue());
                } else {
                    uriBuilder.append(REDACTED_PLACEHOLDER);
                }
                firstQueryParam = false;
            }
        }
        return uriBuilder.toString();
    }

    private UrlRedactionUtil() {
    }
}

