/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TypeUtil {
    private static final Map<Type, Type> SUPER_TYPE_MAP = new ConcurrentHashMap<Type, Type>();

    public static List<Class<?>> getAllClasses(Class<?> clazz) {
        ArrayList types = new ArrayList();
        while (clazz != null) {
            types.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return types;
    }

    public static Type[] getTypeArguments(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return new Type[0];
        }
        return ((ParameterizedType)type).getActualTypeArguments();
    }

    public static Type getTypeArgument(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        return ((ParameterizedType)type).getActualTypeArguments()[0];
    }

    public static Class<?> getRawClass(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    public static Type getSuperType(Type type) {
        Type superType = SUPER_TYPE_MAP.get(type);
        if (superType != null) {
            return superType;
        }
        return SUPER_TYPE_MAP.computeIfAbsent(type, _type -> {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type genericSuperClass = ((Class)parameterizedType.getRawType()).getGenericSuperclass();
                if (genericSuperClass instanceof ParameterizedType) {
                    Type[] superTypeArguments = TypeUtil.getTypeArguments(genericSuperClass);
                    TypeVariable<?>[] typeParameters = ((GenericDeclaration)((Object)parameterizedType.getRawType())).getTypeParameters();
                    int k = 0;
                    block0: for (int i = 0; i != superTypeArguments.length; ++i) {
                        int j = 0;
                        while (i < typeParameters.length) {
                            if (typeParameters[j].equals(superTypeArguments[i])) {
                                superTypeArguments[i] = parameterizedType.getActualTypeArguments()[k++];
                                continue block0;
                            }
                            ++j;
                        }
                    }
                    return TypeUtil.createParameterizedType(((ParameterizedType)genericSuperClass).getRawType(), superTypeArguments);
                }
                return genericSuperClass;
            }
            if (((Class)type).isInterface()) {
                Type[] types;
                for (Type t : types = ((Class)type).getGenericInterfaces()) {
                    if (!(t instanceof ParameterizedType)) continue;
                    return t;
                }
                return null;
            }
            return ((Class)type).getGenericSuperclass();
        });
    }

    public static boolean typeImplementsInterface(Type type, Class<?> interfaceClass) {
        if (TypeUtil.getRawClass(type) == interfaceClass) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtil.typeImplementsInterface(((ParameterizedType)type).getRawType(), interfaceClass);
        }
        Class clazz = (Class)type;
        return Arrays.stream(clazz.getInterfaces()).anyMatch(implementedInterface -> implementedInterface == interfaceClass);
    }

    public static Type getSuperType(Type subType, Class<?> rawSuperType) {
        while (subType != null && TypeUtil.getRawClass(subType) != rawSuperType) {
            subType = TypeUtil.getSuperType(subType);
        }
        return subType;
    }

    public static boolean isTypeOrSubTypeOf(Type subType, Type superType) {
        return TypeUtil.getRawClass(superType).isAssignableFrom(TypeUtil.getRawClass(subType));
    }

    public static ParameterizedType createParameterizedType(final Type rawClass, final Type ... genericTypes) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return genericTypes;
            }

            @Override
            public Type getRawType() {
                return rawClass;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    public static Type getRestResponseBodyType(Type restResponseReturnType) {
        Type[] restResponseTypeArguments = TypeUtil.getTypeArguments(restResponseReturnType);
        if (restResponseTypeArguments != null && restResponseTypeArguments.length > 0) {
            return restResponseTypeArguments[restResponseTypeArguments.length - 1];
        }
        return TypeUtil.getRestResponseBodyType(TypeUtil.getSuperType(restResponseReturnType));
    }

    private TypeUtil() {
    }
}

