/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class AccessibleByteArrayOutputStream
extends ByteArrayOutputStream {
    public AccessibleByteArrayOutputStream() {
    }

    public AccessibleByteArrayOutputStream(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public byte[] toByteArrayUnsafe() {
        return this.buf.length == this.count ? this.buf : this.toByteArray();
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.buf, 0, this.count).asReadOnlyBuffer();
    }

    public int count() {
        return this.count;
    }

    @Override
    public String toString(Charset charset) {
        return new String(this.buf, 0, this.count, charset);
    }
}

