/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.pipeline;

import io.clientcore.core.http.models.HttpHeaders;
import io.clientcore.core.http.pipeline.HttpRetryCondition;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public final class HttpRetryOptions {
    private static final ClientLogger LOGGER = new ClientLogger(HttpRetryOptions.class);
    private final int maxRetries;
    private final Duration baseDelay;
    private final Duration maxDelay;
    private final Duration fixedDelay;
    private Predicate<HttpRetryCondition> shouldRetryCondition;
    private Function<HttpHeaders, Duration> delayFromHeaders;

    public HttpRetryOptions(int maxRetries, Duration baseDelay, Duration maxDelay) {
        Objects.requireNonNull(baseDelay, "'baseDelay' cannot be null.");
        Objects.requireNonNull(maxDelay, "'maxDelay' cannot be null.");
        if (maxRetries < 0) {
            LOGGER.atVerbose().log("Max retries cannot be less than 0. Using 3 retries as the maximum.");
            maxRetries = 3;
        }
        this.baseDelay = baseDelay;
        this.maxDelay = maxDelay;
        this.maxRetries = maxRetries;
        this.fixedDelay = null;
    }

    public HttpRetryOptions(int maxRetries, Duration fixedDelay) {
        Objects.requireNonNull(fixedDelay, "'fixedDelay' cannot be null.");
        if (maxRetries < 0) {
            LOGGER.atVerbose().log("Max retries cannot be less than 0. Using 3 retries as the maximum.");
            maxRetries = 3;
        }
        this.maxRetries = maxRetries;
        this.fixedDelay = fixedDelay;
        this.baseDelay = null;
        this.maxDelay = null;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Duration getBaseDelay() {
        return this.baseDelay;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public Duration getFixedDelay() {
        return this.fixedDelay;
    }

    public Predicate<HttpRetryCondition> getShouldRetryCondition() {
        return this.shouldRetryCondition;
    }

    public HttpRetryOptions setShouldRetryCondition(Predicate<HttpRetryCondition> shouldRetryCondition) {
        this.shouldRetryCondition = shouldRetryCondition;
        return this;
    }

    public Function<HttpHeaders, Duration> getDelayFromHeaders() {
        return this.delayFromHeaders;
    }

    public HttpRetryOptions setDelayFromHeaders(Function<HttpHeaders, Duration> delayFromHeaders) {
        this.delayFromHeaders = delayFromHeaders;
        return this;
    }
}

