/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.pipeline;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpMethod;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.http.pipeline.HttpPipelineNextPolicy;
import io.clientcore.core.http.pipeline.HttpPipelinePolicy;
import io.clientcore.core.http.pipeline.HttpPipelinePosition;
import io.clientcore.core.http.pipeline.HttpRedirectCondition;
import io.clientcore.core.http.pipeline.HttpRedirectOptions;
import io.clientcore.core.implementation.UrlRedactionUtil;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.logging.LoggingEvent;
import io.clientcore.core.models.binarydata.BinaryData;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public final class HttpRedirectPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(HttpRedirectPolicy.class);
    private final int maxAttempts;
    private final Predicate<HttpRedirectCondition> shouldRedirectCondition;
    private static final int DEFAULT_MAX_REDIRECT_ATTEMPTS = 3;
    private static final EnumSet<HttpMethod> DEFAULT_REDIRECT_ALLOWED_METHODS = EnumSet.of(HttpMethod.GET, HttpMethod.HEAD);
    private static final int PERMANENT_REDIRECT_STATUS_CODE = 308;
    private static final int TEMPORARY_REDIRECT_STATUS_CODE = 307;
    private final EnumSet<HttpMethod> allowedRedirectHttpMethods;
    private final HttpHeaderName locationHeader;

    public HttpRedirectPolicy() {
        this(new HttpRedirectOptions(3, HttpHeaderName.LOCATION, DEFAULT_REDIRECT_ALLOWED_METHODS));
    }

    public HttpRedirectPolicy(HttpRedirectOptions redirectOptions) {
        Objects.requireNonNull(redirectOptions, "'redirectOptions' cannot be null.");
        this.maxAttempts = redirectOptions.getMaxAttempts();
        this.shouldRedirectCondition = redirectOptions.getShouldRedirectCondition();
        this.allowedRedirectHttpMethods = redirectOptions.getAllowedRedirectHttpMethods().isEmpty() ? DEFAULT_REDIRECT_ALLOWED_METHODS : redirectOptions.getAllowedRedirectHttpMethods();
        this.locationHeader = redirectOptions.getLocationHeader() == null ? HttpHeaderName.LOCATION : redirectOptions.getLocationHeader();
    }

    @Override
    public Response<BinaryData> process(HttpRequest httpRequest, HttpPipelineNextPolicy next) {
        InstrumentationContext instrumentationContext = httpRequest.getContext().getInstrumentationContext();
        ClientLogger logger = this.getLogger(httpRequest);
        return this.attemptRedirect(logger, next, 0, new LinkedHashSet<String>(), instrumentationContext);
    }

    @Override
    public HttpPipelinePosition getPipelinePosition() {
        return HttpPipelinePosition.REDIRECT;
    }

    private Response<BinaryData> attemptRedirect(ClientLogger logger, HttpPipelineNextPolicy next, int redirectAttempt, LinkedHashSet<String> attemptedRedirectUris, InstrumentationContext instrumentationContext) {
        Response<BinaryData> response = next.copy().process();
        HttpRedirectCondition requestRedirectCondition = new HttpRedirectCondition(response, redirectAttempt, attemptedRedirectUris);
        if (this.shouldRedirectCondition != null && this.shouldRedirectCondition.test(requestRedirectCondition) || this.shouldRedirectCondition == null && this.defaultShouldAttemptRedirect(logger, requestRedirectCondition, instrumentationContext)) {
            this.createRedirectRequest(response);
            return this.attemptRedirect(logger, next, redirectAttempt + 1, attemptedRedirectUris, instrumentationContext);
        }
        return response;
    }

    private boolean defaultShouldAttemptRedirect(ClientLogger logger, HttpRedirectCondition requestRedirectCondition, InstrumentationContext context) {
        Response<BinaryData> response = requestRedirectCondition.getResponse();
        int tryCount = requestRedirectCondition.getTryCount();
        Set<String> attemptedRedirectUris = requestRedirectCondition.getRedirectedUris();
        String redirectUri = response.getHeaders().getValue(this.locationHeader);
        if (this.isValidRedirectStatusCode(response.getStatusCode()) && redirectUri != null) {
            HttpMethod method = response.getRequest().getHttpMethod();
            if (tryCount >= this.maxAttempts - 1) {
                this.logRedirect(logger, true, redirectUri, tryCount, method, "Redirect attempts have been exhausted.", context);
                return false;
            }
            if (!this.allowedRedirectHttpMethods.contains((Object)response.getRequest().getHttpMethod())) {
                this.logRedirect(logger, true, redirectUri, tryCount, method, "Request redirection is not enabled for this HTTP method.", context);
                return false;
            }
            if (attemptedRedirectUris.contains(redirectUri)) {
                this.logRedirect(logger, true, redirectUri, tryCount, method, "Request was redirected more than once to the same URI.", context);
                return false;
            }
            this.logRedirect(logger, false, redirectUri, tryCount, method, null, context);
            attemptedRedirectUris.add(redirectUri);
            return true;
        }
        return false;
    }

    private boolean isValidRedirectStatusCode(int statusCode) {
        return statusCode == 302 || statusCode == 301 || statusCode == 308 || statusCode == 307;
    }

    private void createRedirectRequest(Response<?> redirectResponse) {
        redirectResponse.getRequest().getHeaders().remove(HttpHeaderName.AUTHORIZATION);
        redirectResponse.getRequest().setUri(redirectResponse.getHeaders().getValue(this.locationHeader));
        redirectResponse.close();
    }

    private void logRedirect(ClientLogger logger, boolean lastAttempt, String redirectUri, int tryCount, HttpMethod method, String message, InstrumentationContext context) {
        LoggingEvent log;
        LoggingEvent loggingEvent = log = lastAttempt ? logger.atWarning() : logger.atVerbose();
        if (log.isEnabled()) {
            log.addKeyValue("http.request.resend_count", tryCount).addKeyValue("retry.max_attempt_count", this.maxAttempts).addKeyValue("http.request.method", (Object)method).addKeyValue("http.response.header.location", this.redactUri(redirectUri)).addKeyValue("retry.was_last_attempt", lastAttempt).setEventName("http.redirect").setInstrumentationContext(context).log(message);
        }
    }

    private String redactUri(String location) {
        URI uri;
        try {
            uri = URI.create(location);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return UrlRedactionUtil.getRedactedUri(uri, Collections.emptySet());
    }

    private ClientLogger getLogger(HttpRequest httpRequest) {
        ClientLogger logger = null;
        if (httpRequest.getContext() != null && httpRequest.getContext().getLogger() != null) {
            logger = httpRequest.getContext().getLogger();
        }
        return logger == null ? LOGGER : logger;
    }
}

