/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.pipeline;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpMethod;
import io.clientcore.core.http.pipeline.HttpRedirectCondition;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.util.EnumSet;
import java.util.function.Predicate;

public final class HttpRedirectOptions {
    private static final ClientLogger LOGGER = new ClientLogger(HttpRedirectOptions.class);
    private final int maxAttempts;
    private final EnumSet<HttpMethod> allowedRedirectHttpMethods;
    private final HttpHeaderName locationHeader;
    private Predicate<HttpRedirectCondition> shouldRedirectCondition;

    public HttpRedirectOptions(int maxAttempts, HttpHeaderName locationHeader, EnumSet<HttpMethod> allowedRedirectHttpMethods) {
        if (maxAttempts < 0) {
            throw LOGGER.logThrowableAsError(new IllegalArgumentException("Max attempts cannot be less than 0."));
        }
        this.maxAttempts = maxAttempts;
        this.allowedRedirectHttpMethods = allowedRedirectHttpMethods == null ? EnumSet.noneOf(HttpMethod.class) : allowedRedirectHttpMethods;
        this.locationHeader = locationHeader;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Predicate<HttpRedirectCondition> getShouldRedirectCondition() {
        return this.shouldRedirectCondition;
    }

    public HttpRedirectOptions setShouldRedirectCondition(Predicate<HttpRedirectCondition> shouldRedirectCondition) {
        this.shouldRedirectCondition = shouldRedirectCondition;
        return this;
    }

    public EnumSet<HttpMethod> getAllowedRedirectHttpMethods() {
        return this.allowedRedirectHttpMethods;
    }

    public HttpHeaderName getLocationHeader() {
        return this.locationHeader;
    }
}

