/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.models;

import io.clientcore.core.http.models.Response;
import io.clientcore.core.implementation.http.RetryUtils;
import io.clientcore.core.models.CoreException;
import io.clientcore.core.models.binarydata.BinaryData;

public class HttpResponseException
extends CoreException {
    private final Object value;
    private final Response<BinaryData> response;
    private final boolean isRetryable;

    public HttpResponseException(String message, Response<BinaryData> response, Object value) {
        super(message, null);
        this.value = value;
        this.response = response;
        this.isRetryable = response == null || RetryUtils.isRetryable(response.getStatusCode());
    }

    public HttpResponseException(String message, Response<BinaryData> response, Throwable cause) {
        super(message, cause);
        this.value = null;
        this.response = response;
        this.isRetryable = response != null ? RetryUtils.isRetryable(response.getStatusCode()) : RetryUtils.isRetryable(cause);
    }

    public Response<BinaryData> getResponse() {
        return this.response;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isRetryable() {
        return this.isRetryable;
    }
}

