/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.models;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.util.Objects;

public final class HttpRange {
    private static final ClientLogger LOGGER = new ClientLogger(HttpRange.class);
    private final long offset;
    private final Long length;

    public HttpRange(long offset) {
        this(offset, null);
    }

    public HttpRange(long offset, Long length) {
        if (offset < 0L) {
            throw LOGGER.logThrowableAsError(new IllegalArgumentException("'offset' cannot be less than 0."));
        }
        if (length != null && length <= 0L) {
            throw LOGGER.logThrowableAsError(new IllegalArgumentException("'length' cannot be equal to or less than 0."));
        }
        this.offset = offset;
        this.length = length;
    }

    public long getOffset() {
        return this.offset;
    }

    public Long getLength() {
        return this.length;
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.length);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HttpRange)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        HttpRange other = (HttpRange)obj;
        return other.offset == this.offset && Objects.equals(other.length, this.length);
    }

    public String toString() {
        return this.length == null ? "bytes=" + this.offset + "-" : "bytes=" + this.offset + "-" + (this.offset + this.length - 1L);
    }
}

