/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http;

import io.clientcore.core.http.models.RequestContext;
import io.clientcore.core.http.pipeline.HttpPipeline;
import io.clientcore.core.implementation.http.rest.RestProxyImpl;
import io.clientcore.core.implementation.http.rest.SwaggerInterfaceParser;
import io.clientcore.core.implementation.http.rest.SwaggerMethodParser;
import io.clientcore.core.serialization.ObjectSerializer;
import io.clientcore.core.serialization.json.JsonSerializer;
import io.clientcore.core.serialization.xml.XmlSerializer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class RestProxy
implements InvocationHandler {
    private final SwaggerInterfaceParser interfaceParser;
    private final RestProxyImpl restProxyImpl;

    private RestProxy(HttpPipeline httpPipeline, SwaggerInterfaceParser interfaceParser, ObjectSerializer ... serializers) {
        this.interfaceParser = interfaceParser;
        this.restProxyImpl = new RestProxyImpl(httpPipeline, interfaceParser, serializers);
    }

    private SwaggerMethodParser getMethodParser(Method method) {
        return this.interfaceParser.getMethodParser(method);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        SwaggerMethodParser methodParser = this.getMethodParser(method);
        RequestContext options = methodParser.setRequestContext(args);
        return this.restProxyImpl.invoke(proxy, options, methodParser, args);
    }

    public static <A> A create(Class<A> swaggerInterface, HttpPipeline httpPipeline) {
        SwaggerInterfaceParser interfaceParser = SwaggerInterfaceParser.getInstance(swaggerInterface);
        RestProxy restProxy = new RestProxy(httpPipeline, interfaceParser, new JsonSerializer(), new XmlSerializer());
        return (A)Proxy.newProxyInstance(swaggerInterface.getClassLoader(), new Class[]{swaggerInterface}, (InvocationHandler)restProxy);
    }

    public static <A> A create(Class<A> swaggerInterface, HttpPipeline httpPipeline, ObjectSerializer ... serializers) {
        SwaggerInterfaceParser interfaceParser = SwaggerInterfaceParser.getInstance(swaggerInterface);
        RestProxy restProxy = new RestProxy(httpPipeline, interfaceParser, serializers);
        return (A)Proxy.newProxyInstance(swaggerInterface.getClassLoader(), new Class[]{swaggerInterface}, (InvocationHandler)restProxy);
    }
}

