/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.credentials.oauth;

import io.clientcore.core.utils.ExpandableEnum;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class AccessTokenType
implements ExpandableEnum<String> {
    private static final Map<String, AccessTokenType> VALUES = new ConcurrentHashMap<String, AccessTokenType>();
    private final String caseSensitive;
    private final String caseInsensitive;
    public static final AccessTokenType BEARER = AccessTokenType.fromString("Bearer");
    public static final AccessTokenType POP = AccessTokenType.fromString("Pop");

    private AccessTokenType(String name) {
        this.caseSensitive = name;
        this.caseInsensitive = name.toLowerCase();
    }

    @Override
    public String getValue() {
        return this.caseSensitive;
    }

    public String getCaseSensitiveName() {
        return this.toString();
    }

    public String getCaseInsensitiveName() {
        return this.caseInsensitive;
    }

    public static AccessTokenType fromString(String name) {
        if (name == null) {
            return null;
        }
        AccessTokenType accessTokenType = VALUES.get(name);
        if (accessTokenType != null) {
            return accessTokenType;
        }
        return VALUES.computeIfAbsent(name, AccessTokenType::new);
    }

    public String toString() {
        return this.caseSensitive;
    }

    public int hashCode() {
        return this.caseInsensitive.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccessTokenType)) {
            return false;
        }
        AccessTokenType other = (AccessTokenType)obj;
        return Objects.equals(this.caseInsensitive, other.caseInsensitive);
    }
}

