/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.http.client;

import io.clientcore.core.implementation.http.client.JdkHttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;

final class InputStreamTimeoutResponseSubscriber
extends InputStream
implements HttpResponse.BodySubscriber<InputStream> {
    private static final ByteBuffer LAST_BUFFER = ByteBuffer.wrap(new byte[0]);
    private static final List<ByteBuffer> LAST_LIST = List.of(LAST_BUFFER);
    private final BlockingQueue<List<ByteBuffer>> buffers;
    private volatile Flow.Subscription subscription;
    private volatile boolean subscribed;
    private volatile boolean closed;
    private volatile Throwable failed;
    private volatile Iterator<ByteBuffer> currentListItr;
    private volatile ByteBuffer currentBuffer;
    private final Semaphore semaphore = new Semaphore(1);
    private final long readTimeout;
    private ScheduledFuture<?> currentTimeout;

    InputStreamTimeoutResponseSubscriber(long readTimeout) {
        this.buffers = new ArrayBlockingQueue<List<ByteBuffer>>(2);
        this.readTimeout = readTimeout;
    }

    @Override
    public CompletionStage<InputStream> getBody() {
        return CompletableFuture.completedStage(this);
    }

    private ByteBuffer current() throws IOException {
        while (this.currentBuffer == null || !this.currentBuffer.hasRemaining()) {
            this.validateState();
            if (this.currentBuffer == LAST_BUFFER) break;
            try {
                if (this.currentListItr == null || !this.currentListItr.hasNext()) {
                    List<ByteBuffer> lb = this.buffers.take();
                    this.currentListItr = lb.iterator();
                    this.validateState();
                    if (lb == LAST_LIST) {
                        this.currentListItr = null;
                        this.currentBuffer = LAST_BUFFER;
                        break;
                    }
                    Flow.Subscription s = this.subscription;
                    if (s != null) {
                        this.currentTimeout = this.createTimeout();
                        s.request(1L);
                    }
                    if (lb.isEmpty()) continue;
                }
                this.currentBuffer = this.currentListItr.next();
            }
            catch (InterruptedException ex) {
                this.close();
                Thread.currentThread().interrupt();
                throw new IOException(ex);
            }
        }
        return this.currentBuffer;
    }

    private void validateState() throws IOException {
        if (this.closed) {
            if (this.failed instanceof HttpTimeoutException) {
                throw (HttpTimeoutException)this.failed;
            }
            throw new IOException("closed", this.failed);
        }
        if (this.failed != null) {
            if (this.failed instanceof HttpTimeoutException) {
                throw (HttpTimeoutException)this.failed;
            }
            throw new IOException(this.failed);
        }
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        Objects.checkFromIndexSize(off, len, bytes.length);
        if (len == 0) {
            return 0;
        }
        ByteBuffer buffer = this.current();
        if (buffer == LAST_BUFFER) {
            return -1;
        }
        int read = Math.min(buffer.remaining(), len);
        buffer.get(bytes, off, read);
        return read;
    }

    @Override
    public int read() throws IOException {
        ByteBuffer buffer = this.current();
        if (buffer == LAST_BUFFER) {
            return -1;
        }
        return buffer.get() & 0xFF;
    }

    @Override
    public int available() {
        if (this.closed) {
            return 0;
        }
        int available = 0;
        ByteBuffer current = this.currentBuffer;
        if (current == LAST_BUFFER) {
            return 0;
        }
        if (current != null) {
            available = current.remaining();
        }
        if (available != 0) {
            return available;
        }
        Iterator<ByteBuffer> iterator = this.currentListItr;
        if (iterator != null && iterator.hasNext()) {
            return 1;
        }
        if (this.buffers.isEmpty()) {
            return 0;
        }
        return 1;
    }

    @Override
    public void onSubscribe(Flow.Subscription s) {
        if (this.subscribed) {
            s.cancel();
            return;
        }
        boolean closed = this.closed;
        if (closed) {
            s.cancel();
            return;
        }
        this.subscription = s;
        this.subscribed = true;
        this.currentTimeout = this.createTimeout();
        s.request(1L);
    }

    @Override
    public void onNext(List<ByteBuffer> t) {
        this.currentTimeout.cancel(false);
        Objects.requireNonNull(t);
        if (!this.buffers.offer(t)) {
            IllegalStateException ex = new IllegalStateException("queue is full");
            this.failed = ex;
            this.close();
            this.onError(ex);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.currentTimeout.cancel(true);
        this.subscription = null;
        if (this.failed != null) {
            this.failed.addSuppressed(throwable);
        } else {
            this.failed = Objects.requireNonNull(throwable);
        }
        this.buffers.offer(LAST_LIST);
    }

    @Override
    public void onComplete() {
        this.currentTimeout.cancel(true);
        this.subscription = null;
        this.onNext(LAST_LIST);
    }

    @Override
    public void close() {
        Flow.Subscription s;
        this.semaphore.acquireUninterruptibly();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            s = this.subscription;
            this.subscription = null;
        }
        finally {
            this.semaphore.release();
        }
        try {
            if (s != null) {
                s.cancel();
            }
        }
        finally {
            this.buffers.offer(LAST_LIST);
        }
    }

    private ScheduledFuture<?> createTimeout() {
        return JdkHttpUtils.scheduleTimeoutTask(() -> {
            this.failed = new HttpTimeoutException("Timeout reading response body.");
            this.subscription.cancel();
            this.close();
        }, this.readTimeout);
    }
}

