/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.http.client;

import io.clientcore.core.http.models.HttpHeaders;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

final class HeaderFilteringMap
extends AbstractMap<String, List<String>> {
    private final HttpHeaders headers;
    private final Set<String> restrictedHeaders;
    private final ClientLogger logger;

    HeaderFilteringMap(HttpHeaders headers, Set<String> restrictedHeaders, ClientLogger logger) {
        this.headers = headers;
        this.restrictedHeaders = restrictedHeaders;
        this.logger = logger;
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        throw this.logger.logThrowableAsError(new UnsupportedOperationException("The only operation permitted by this Map is forEach."));
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super List<String>> action) {
        this.headers.stream().forEach((? super T header) -> {
            if (this.restrictedHeaders.contains(header.getName().getCaseInsensitiveName())) {
                this.logger.atWarning().addKeyValue("headerName", header.getName()).log("The header is restricted by 'java.net.http.HttpClient' and will be ignored. To allow this header to be set on the request, configure 'jdk.httpclient.allowRestrictedHeaders' with the header added in the comma-separated list.");
            } else {
                action.accept(header.getName().getValue(), header.getValues());
            }
        });
    }
}

