/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils.configuration;

import io.clientcore.core.utils.configuration.ConfigurationSource;
import io.clientcore.core.utils.configuration.EnvironmentVariableConfigurationSource;
import io.clientcore.core.utils.configuration.SystemPropertiesConfigurationSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Configuration {
    public static final String HTTP_PROXY = "HTTP_PROXY";
    public static final String HTTPS_PROXY = "HTTPS_PROXY";
    public static final String NO_PROXY = "NO_PROXY";
    public static final String LOG_LEVEL = "LOG_LEVEL";
    public static final String HTTP_LOG_LEVEL = "HTTP_LOG_LEVEL";
    public static final String MAX_RETRY_ATTEMPTS = "MAX_RETRY_ATTEMPTS";
    public static final String REQUEST_CONNECT_TIMEOUT_IN_MS = "REQUEST_CONNECT_TIMEOUT_IN_MS";
    public static final String REQUEST_WRITE_TIMEOUT_IN_MS = "REQUEST_WRITE_TIMEOUT_IN_MS";
    public static final String REQUEST_RESPONSE_TIMEOUT_IN_MS = "REQUEST_RESPONSE_TIMEOUT_IN_MS";
    public static final String REQUEST_READ_TIMEOUT_IN_MS = "REQUEST_READ_TIMEOUT_IN_MS";
    public static final String HTTP_CLIENT_IMPLEMENTATION = "HTTP_CLIENT_IMPLEMENTATION";
    private static final Configuration GLOBAL_CONFIGURATION = Configuration.from(new SystemPropertiesConfigurationSource(), new EnvironmentVariableConfigurationSource());
    private static final Configuration NONE = new Configuration(Collections.emptyList());
    private final List<ConfigurationSource> sources;

    private Configuration(List<ConfigurationSource> sources) {
        this.sources = sources;
    }

    public static Configuration from(ConfigurationSource ... sources) {
        if (sources == null) {
            throw new IllegalArgumentException("Sources cannot be null");
        }
        if (sources.length == 0) {
            return NONE;
        }
        ArrayList<ConfigurationSource> sourceList = new ArrayList<ConfigurationSource>(sources.length);
        for (ConfigurationSource source : sources) {
            if (source == null) {
                throw new IllegalArgumentException("Source cannot be null");
            }
            sourceList.add(source);
        }
        return new Configuration(sourceList);
    }

    public static Configuration getGlobalConfiguration() {
        return GLOBAL_CONFIGURATION;
    }

    public static Configuration none() {
        return NONE;
    }

    public String get(String name) {
        if (this.sources == null || name == null) {
            return null;
        }
        return this.getInternal(name);
    }

    public String get(String name, String ... aliases) {
        if (this.sources == null) {
            return null;
        }
        String value = this.getInternal(name);
        if (value != null) {
            return value;
        }
        if (aliases != null) {
            for (String alias : aliases) {
                value = this.getInternal(alias);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    private String getInternal(String name) {
        if (name == null) {
            return null;
        }
        for (ConfigurationSource source : this.sources) {
            String value = source.getProperty(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

