/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpHeaders;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.utils.AuthUtils;
import io.clientcore.core.utils.AuthenticateChallenge;
import io.clientcore.core.utils.ChallengeHandler;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class DigestChallengeHandler
implements ChallengeHandler {
    private final String username;
    private final String password;
    private final Map<String, String> digestCache;
    private static final String REALM = "realm";
    private static final String NONCE = "nonce";
    private static final String QOP = "qop";
    private static final String AUTH = "auth";
    private static final String AUTH_INT = "auth-int";
    private static final String USERHASH = "userhash";
    private static final String OPAQUE = "opaque";
    private final SecureRandom nonceGenerator = new SecureRandom();
    private final Map<String, AtomicInteger> nonceTracker = new ConcurrentHashMap<String, AtomicInteger>();
    private static final String SHA_512_256_SESS = "SHA-512-256-SESS";
    private static final String SHA_256 = "SHA-256";
    private static final String SHA_256_SESS = "SHA-256-SESS";
    private static final String MD5_SESS = "MD5-SESS";
    private static final String[] ALGORITHM_PREFERENCE_ORDER = new String[]{"SHA-512-256", "SHA-512-256-SESS", "SHA-256", "SHA-256-SESS", "MD5", "MD5-SESS"};

    public DigestChallengeHandler(String username, String password) {
        this.username = username;
        this.password = password;
        this.digestCache = new HashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleChallenge(HttpRequest request, Response<BinaryData> response, boolean isProxy) {
        String authHeader;
        if (!this.canHandle(response, isProxy)) {
            return;
        }
        HttpHeaderName authHeaderName = isProxy ? HttpHeaderName.PROXY_AUTHENTICATE : HttpHeaderName.WWW_AUTHENTICATE;
        String string = authHeader = response.getHeaders() != null ? response.getHeaders().getValue(authHeaderName) : null;
        if (authHeader != null && authHeader.contains(NONCE)) {
            this.updateDigestCache(authHeader);
        }
        Map<String, List<Map<String, String>>> challengesByType = AuthUtils.partitionByChallengeType(response.getHeaders());
        for (String algorithm : ALGORITHM_PREFERENCE_ORDER) {
            Function<byte[], byte[]> digestFunction;
            if (!challengesByType.containsKey(algorithm.toUpperCase(Locale.ROOT)) || (digestFunction = AuthUtils.getDigestFunction(algorithm)) == null) continue;
            String digestAuthHeader = this.generateDigestAuthHeader(request.getHttpMethod().name(), request.getUri().toString(), algorithm, digestFunction, response.getValue());
            HttpHeaders httpHeaders = request.getHeaders();
            synchronized (httpHeaders) {
                HttpHeaderName headerName = isProxy ? HttpHeaderName.PROXY_AUTHORIZATION : HttpHeaderName.AUTHORIZATION;
                request.getHeaders().set(headerName, digestAuthHeader);
            }
        }
    }

    @Override
    public boolean canHandle(Response<BinaryData> response, boolean isProxy) {
        if (response.getHeaders() != null) {
            HttpHeaderName authHeaderName = isProxy ? HttpHeaderName.PROXY_AUTHENTICATE : HttpHeaderName.WWW_AUTHENTICATE;
            String authHeader = response.getHeaders().getValue(authHeaderName);
            if (authHeader != null) {
                List<AuthenticateChallenge> challenges = AuthUtils.parseAuthenticateHeader(authHeader);
                for (AuthenticateChallenge challenge : challenges) {
                    if (!"Digest".equalsIgnoreCase(challenge.getScheme())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void updateDigestCache(String authHeader) {
        String nonce = AuthUtils.extractValue(authHeader, NONCE);
        String realm = AuthUtils.extractValue(authHeader, REALM);
        String qop = AuthUtils.extractValue(authHeader, QOP);
        String hashUsername = AuthUtils.extractValue(authHeader, USERHASH);
        String opaque = AuthUtils.extractValue(authHeader, OPAQUE);
        this.digestCache.put(NONCE, nonce);
        this.digestCache.put(REALM, realm);
        this.digestCache.put(QOP, qop);
        this.digestCache.put(USERHASH, hashUsername);
        this.digestCache.put(OPAQUE, opaque);
    }

    String generateCnonce() {
        byte[] nonce = new byte[16];
        this.nonceGenerator.nextBytes(nonce);
        return AuthUtils.bytesToHexString(nonce);
    }

    private String generateDigestAuthHeader(String method, String uri, String algorithm, Function<byte[], byte[]> digestFunction, BinaryData body) {
        String nonce = this.digestCache.get(NONCE);
        String realm = this.digestCache.get(REALM);
        String qop = this.digestCache.get(QOP);
        String opaque = this.digestCache.get(OPAQUE);
        boolean hashUsername = Boolean.parseBoolean(this.digestCache.get(USERHASH));
        int nc = 0;
        String clientNonce = null;
        if (AUTH.equals(qop) || AUTH_INT.equals(qop)) {
            clientNonce = this.generateCnonce();
            nc = this.getOrUpdateNonceCount(nonce);
        } else if (algorithm.endsWith("-SESS")) {
            clientNonce = this.generateCnonce();
        }
        String ha1 = algorithm.endsWith("-SESS") ? AuthUtils.calculateHa1Sess(digestFunction, this.username, realm, this.password, nonce, clientNonce) : AuthUtils.calculateHa1NoSess(digestFunction, this.username, realm, this.password);
        String ha2 = AUTH_INT.equals(qop) ? AuthUtils.calculateHa2AuthIntQop(digestFunction, method, uri, body.toBytes()) : AuthUtils.calculateHa2AuthQopOrEmpty(digestFunction, method, uri);
        String response = AUTH.equals(qop) || AUTH_INT.equals(qop) ? AuthUtils.calculateResponseKnownQop(digestFunction, ha1, nonce, nc, clientNonce, qop, ha2) : AuthUtils.calculateResponseUnknownQop(digestFunction, ha1, nonce, ha2);
        String headerUsername = hashUsername ? AuthUtils.calculateUserhash(digestFunction, this.username, realm) : this.username;
        return AuthUtils.buildAuthorizationHeader(headerUsername, realm, uri, algorithm, nonce, nc, clientNonce, qop, response, opaque, hashUsername);
    }

    private int getOrUpdateNonceCount(String nonce) {
        return this.nonceTracker.compute(nonce, (ignored, value) -> {
            if (value == null) {
                return new AtomicInteger(1);
            }
            value.incrementAndGet();
            return value;
        }).get();
    }
}

