/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.xml.implementation.aalto.out;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;

public final class WName {
    final String _prefix;
    final String _localName;
    final char[] _chars;

    WName(String ln) {
        this._prefix = null;
        this._localName = ln;
        this._chars = ln.toCharArray();
    }

    WName(String prefix, String ln) {
        this._prefix = prefix;
        this._localName = ln;
        int plen = prefix.length();
        int llen = ln.length();
        this._chars = new char[plen + 1 + llen];
        prefix.getChars(0, plen, this._chars, 0);
        this._chars[plen] = 58;
        ln.getChars(0, llen, this._chars, plen + 1);
    }

    public int serializedLength() {
        return this._chars.length;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public String getLocalName() {
        return this._localName;
    }

    public void appendChars(char[] buffer, int offset) {
        int len = this._chars.length;
        System.arraycopy(this._chars, 0, buffer, offset, len);
    }

    public void writeChars(Writer w) throws IOException {
        w.write(this._chars);
    }

    public String toString() {
        if (this._prefix != null) {
            return new String(this._chars);
        }
        return this._localName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        WName other = (WName)o;
        if (other._localName.equals(this._localName)) {
            if (this._prefix == null) {
                return other._prefix == null;
            }
            return this._prefix.equals(other._prefix);
        }
        return false;
    }

    public int hashCode() {
        int hash = this._localName.hashCode();
        if (this._prefix != null) {
            hash ^= this._prefix.hashCode();
        }
        return hash;
    }

    public boolean hasName(String localName) {
        if (this._prefix != null) {
            return false;
        }
        return this._localName.equals(localName);
    }

    public boolean hasName(String prefix, String localName) {
        if (Objects.equals(this._localName, localName)) {
            if (prefix == null) {
                return this._prefix == null;
            }
            return prefix.equals(this._prefix);
        }
        if (this._localName.hashCode() != localName.hashCode()) {
            return false;
        }
        if (prefix == null ? this._prefix != null : !prefix.equals(this._prefix)) {
            return false;
        }
        return this._localName.equals(localName);
    }
}

