/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.xml.implementation.aalto.in;

import io.clientcore.core.serialization.xml.implementation.aalto.impl.LocationImpl;
import io.clientcore.core.serialization.xml.implementation.aalto.impl.StreamExceptionBase;
import io.clientcore.core.serialization.xml.implementation.aalto.in.ReaderConfig;
import io.clientcore.core.serialization.xml.implementation.aalto.in.ReaderScanner;
import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public final class CharSourceBootstrapper {
    static final char CHAR_BOM_MARKER = '\ufeff';
    public static final String ERR_XMLDECL_KW_VERSION = "; expected keyword 'version'";
    public static final String ERR_XMLDECL_END_MARKER = "; expected \"?>\" end marker";
    public static final String ERR_XMLDECL_EXP_EQ = "; expected '=' after ";
    public static final String ERR_XMLDECL_EXP_ATTRVAL = "; expected a quote character enclosing value for ";
    private int _inputProcessed = 0;
    private int _inputRow = 0;
    private int _inputRowStart = 0;
    final ReaderConfig _config;
    int mDeclaredXmlVersion = 0;
    String mFoundEncoding;
    String mStandalone;
    final char[] mKeyword;
    final Reader _in;
    final char[] _inputBuffer;
    private int _inputPtr;
    private int _inputLast;

    private CharSourceBootstrapper(ReaderConfig cfg, Reader r) {
        this._config = cfg;
        this.mKeyword = new char[60];
        this._in = r;
        this._inputBuffer = new char[4000];
        this._inputPtr = 0;
        this._inputLast = 0;
    }

    public static CharSourceBootstrapper construct(ReaderConfig cfg, Reader r) throws XMLStreamException {
        return new CharSourceBootstrapper(cfg, r);
    }

    private void readXmlDeclaration() throws IOException, XMLStreamException {
        int c = this.getNextAfterWs();
        if (c != 118) {
            this.reportUnexpectedChar(c, ERR_XMLDECL_KW_VERSION);
        } else {
            this.mDeclaredXmlVersion = this.readXmlVersion();
            c = this.getWsOrChar();
        }
        if (c == 101) {
            this.mFoundEncoding = this.readXmlEncoding();
            c = this.getWsOrChar();
        }
        if (c == 115) {
            this.mStandalone = this.readXmlStandalone();
            c = this.getWsOrChar();
        }
        if (c != 63) {
            this.reportUnexpectedChar(c, ERR_XMLDECL_END_MARKER);
        }
        if ((c = this.getNext()) != 62) {
            this.reportUnexpectedChar(c, ERR_XMLDECL_END_MARKER);
        }
    }

    private int readXmlVersion() throws IOException, XMLStreamException {
        int len;
        int c = this.checkKeyword("version");
        if (c != 0) {
            this.reportUnexpectedChar(c, "version");
        }
        if ((len = this.readQuotedValue(this.mKeyword, c = this.handleEq("version"))) == 3 && this.mKeyword[0] == '1' && this.mKeyword[1] == '.') {
            c = this.mKeyword[2];
            if (c == 48) {
                return 256;
            }
            if (c == 49) {
                return 272;
            }
        }
        String got = len < 0 ? "'" + new String(this.mKeyword) + "[..]'" : (len == 0 ? "<empty>" : "'" + new String(this.mKeyword, 0, len) + "'");
        this.reportPseudoAttrProblem("version", got, "1.0", "1.1");
        return 0;
    }

    private String readXmlEncoding() throws IOException, XMLStreamException {
        int len;
        int c = this.checkKeyword("encoding");
        if (c != 0) {
            this.reportUnexpectedChar(c, "encoding");
        }
        if ((len = this.readQuotedValue(this.mKeyword, c = this.handleEq("encoding"))) == 0) {
            this.reportPseudoAttrProblem("encoding", null, null, null);
        }
        if (len < 0) {
            return new String(this.mKeyword);
        }
        return new String(this.mKeyword, 0, len);
    }

    private String readXmlStandalone() throws IOException, XMLStreamException {
        int len;
        int c = this.checkKeyword("standalone");
        if (c != 0) {
            this.reportUnexpectedChar(c, "standalone");
        }
        if ((len = this.readQuotedValue(this.mKeyword, c = this.handleEq("standalone"))) == 2) {
            if (this.mKeyword[0] == 'n' && this.mKeyword[1] == 'o') {
                return "no";
            }
        } else if (len == 3 && this.mKeyword[0] == 'y' && this.mKeyword[1] == 'e' && this.mKeyword[2] == 's') {
            return "yes";
        }
        String got = len < 0 ? "'" + new String(this.mKeyword) + "[..]'" : (len == 0 ? "<empty>" : "'" + new String(this.mKeyword, 0, len) + "'");
        this.reportPseudoAttrProblem("standalone", got, "yes", "no");
        return got;
    }

    private int handleEq(String attr) throws IOException, XMLStreamException {
        int c = this.getNextAfterWs();
        if (c != 61) {
            this.reportUnexpectedChar(c, "; expected '=' after '" + attr + "'");
        }
        if ((c = this.getNextAfterWs()) != 34 && c != 39) {
            this.reportUnexpectedChar(c, "; expected a quote character enclosing value for '" + attr + "'");
        }
        return c;
    }

    private int getWsOrChar() throws IOException, XMLStreamException {
        int c = this.getNext();
        if (c == 63) {
            return c;
        }
        if (c > 32) {
            this.reportUnexpectedChar(c, "; expected either '?' or white space");
        }
        if (c == 10 || c == 13) {
            this.pushback();
        }
        return this.getNextAfterWs();
    }

    public ReaderScanner bootstrap() throws XMLStreamException {
        try {
            return this.doBootstrap();
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
    }

    public ReaderScanner doBootstrap() throws IOException, XMLStreamException {
        if (this._inputPtr >= this._inputLast) {
            this.initialLoad();
        }
        if (this._inputLast - this._inputPtr >= 7) {
            char c = this._inputBuffer[this._inputPtr];
            if (c == '\ufeff') {
                c = this._inputBuffer[++this._inputPtr];
            }
            if (c == '<') {
                if (this._inputBuffer[this._inputPtr + 1] == '?' && this._inputBuffer[this._inputPtr + 2] == 'x' && this._inputBuffer[this._inputPtr + 3] == 'm' && this._inputBuffer[this._inputPtr + 4] == 'l' && this._inputBuffer[this._inputPtr + 5] <= ' ') {
                    this._inputPtr += 6;
                    this.readXmlDeclaration();
                }
            } else if (c == '\u00ef') {
                throw new StreamExceptionBase("Unexpected first character (char code 0xEF), not valid in xml document: could be mangled UTF-8 BOM marker. Make sure that the Reader uses correct encoding or pass an InputStream instead");
            }
        }
        this._config.setXmlDeclInfo(this.mDeclaredXmlVersion, this.mFoundEncoding, this.mStandalone);
        return new ReaderScanner(this._config, this._in, this._inputBuffer, this._inputPtr, this._inputLast);
    }

    private void initialLoad() throws IOException {
        this._inputPtr = 0;
        this._inputLast = 0;
        while (this._inputLast < 7) {
            int count = this._in.read(this._inputBuffer, this._inputLast, this._inputBuffer.length - this._inputLast);
            if (count < 1) {
                return;
            }
            this._inputLast += count;
        }
    }

    private void loadMore() throws IOException, XMLStreamException {
        this._inputProcessed += this._inputLast;
        this._inputRowStart -= this._inputLast;
        this._inputPtr = 0;
        this._inputLast = this._in.read(this._inputBuffer, 0, this._inputBuffer.length);
        if (this._inputLast < 1) {
            this.reportEof();
        }
    }

    private void pushback() {
        --this._inputPtr;
    }

    private int getNext() throws IOException, XMLStreamException {
        return this._inputPtr < this._inputLast ? this._inputBuffer[this._inputPtr++] : this.nextChar();
    }

    private int getNextAfterWs() throws IOException, XMLStreamException {
        while (true) {
            char c;
            char c2 = c = this._inputPtr < this._inputLast ? this._inputBuffer[this._inputPtr++] : this.nextChar();
            if (c > ' ') {
                return c;
            }
            if (c == '\r' || c == '\n') {
                this.skipCRLF(c);
                continue;
            }
            if (c != '\u0000') continue;
            this.reportNull();
        }
    }

    private int checkKeyword(String exp) throws IOException, XMLStreamException {
        int len = exp.length();
        for (int ptr = 1; ptr < len; ++ptr) {
            char c;
            char c2 = c = this._inputPtr < this._inputLast ? this._inputBuffer[this._inputPtr++] : this.nextChar();
            if (c != exp.charAt(ptr)) {
                return c;
            }
            if (c != '\u0000') continue;
            this.reportNull();
        }
        return 0;
    }

    private int readQuotedValue(char[] kw, int quoteChar) throws IOException, XMLStreamException {
        int i = 0;
        int len = kw.length;
        while (true) {
            char c;
            char c2 = c = this._inputPtr < this._inputLast ? this._inputBuffer[this._inputPtr++] : this.nextChar();
            if (c == '\r' || c == '\n') {
                this.skipCRLF(c);
            } else if (c == '\u0000') {
                this.reportNull();
            }
            if (c == quoteChar) {
                return i < len ? i : -1;
            }
            if (i >= len) continue;
            kw[i++] = c;
        }
    }

    private Location getLocation() {
        return LocationImpl.fromZeroBased(this._inputProcessed + this._inputPtr, this._inputRow, this._inputPtr - this._inputRowStart);
    }

    private char nextChar() throws IOException, XMLStreamException {
        if (this._inputPtr >= this._inputLast) {
            this.loadMore();
        }
        return this._inputBuffer[this._inputPtr++];
    }

    private void skipCRLF(char lf) throws IOException, XMLStreamException {
        if (lf == '\r') {
            char c;
            char c2 = c = this._inputPtr < this._inputLast ? this._inputBuffer[this._inputPtr++] : this.nextChar();
            if (c != '\n') {
                --this._inputPtr;
            }
        }
        ++this._inputRow;
        this._inputRowStart = this._inputPtr;
    }

    private void reportXmlProblem(String msg) throws XMLStreamException {
        throw new StreamExceptionBase(msg, this.getLocation());
    }

    private void reportNull() throws XMLStreamException {
        this.reportXmlProblem("Illegal null byte/char in input stream");
    }

    private void reportEof() throws XMLStreamException {
        this.reportXmlProblem("Unexpected end-of-input in xml declaration");
    }

    private void reportUnexpectedChar(int i, String msg) throws XMLStreamException {
        String excMsg = Character.isISOControl((char)i) ? "Unexpected character (CTRL-CHAR, code " + i + ")" + msg : "Unexpected character '" + (char)i + "' (code " + i + ")" + msg;
        this.reportXmlProblem(excMsg);
    }

    private void reportPseudoAttrProblem(String attrName, String got, String expVal1, String expVal2) throws XMLStreamException {
        String expStr;
        String string = expStr = expVal1 == null ? "" : "; expected \"" + expVal1 + "\" or \"" + expVal2 + "\"";
        if (got == null || got.isEmpty()) {
            this.reportXmlProblem("Missing XML pseudo-attribute '" + attrName + "' value" + expStr);
        }
        this.reportXmlProblem("Invalid XML pseudo-attribute '" + attrName + "' value " + got + expStr);
    }
}

