/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.otel;

import io.clientcore.core.http.models.RequestContext;
import io.clientcore.core.implementation.ReflectionUtils;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.implementation.instrumentation.InstrumentationUtils;
import io.clientcore.core.implementation.instrumentation.NoopAttributes;
import io.clientcore.core.implementation.instrumentation.NoopMeter;
import io.clientcore.core.implementation.instrumentation.SdkInstrumentationOptionsAccessHelper;
import io.clientcore.core.implementation.instrumentation.otel.FallbackInvoker;
import io.clientcore.core.implementation.instrumentation.otel.OTelAttributes;
import io.clientcore.core.implementation.instrumentation.otel.OTelInitializer;
import io.clientcore.core.implementation.instrumentation.otel.metrics.OTelMeter;
import io.clientcore.core.implementation.instrumentation.otel.tracing.OTelSpan;
import io.clientcore.core.implementation.instrumentation.otel.tracing.OTelSpanContext;
import io.clientcore.core.implementation.instrumentation.otel.tracing.OTelTraceContextPropagator;
import io.clientcore.core.implementation.instrumentation.otel.tracing.OTelTracer;
import io.clientcore.core.instrumentation.Instrumentation;
import io.clientcore.core.instrumentation.InstrumentationAttributes;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.InstrumentationOptions;
import io.clientcore.core.instrumentation.SdkInstrumentationOptions;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.metrics.DoubleHistogram;
import io.clientcore.core.instrumentation.metrics.Meter;
import io.clientcore.core.instrumentation.tracing.Span;
import io.clientcore.core.instrumentation.tracing.SpanKind;
import io.clientcore.core.instrumentation.tracing.TraceContextPropagator;
import io.clientcore.core.instrumentation.tracing.Tracer;
import io.clientcore.core.instrumentation.tracing.TracingScope;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class OTelInstrumentation
implements Instrumentation {
    private static final FallbackInvoker GET_TRACER_PROVIDER_INVOKER;
    private static final FallbackInvoker GET_METER_PROVIDER_INVOKER;
    private static final FallbackInvoker GET_GLOBAL_OTEL_INVOKER;
    private static final Object NOOP_PROVIDER;
    private static final OTelTraceContextPropagator W3C_PROPAGATOR_INSTANCE;
    private static final ClientLogger LOGGER;
    public static final OTelInstrumentation DEFAULT_INSTANCE;
    private final boolean isTracingEnabled;
    private final boolean isMetricsEnabled;
    private final boolean allowNestedSpans;
    private final DoubleHistogram callDurationMetric;
    private final Tracer tracer;
    private final Meter meter;
    private final String host;
    private final int port;
    private final Map<String, InstrumentationAttributes> commonAttributesCache = new ConcurrentHashMap<String, InstrumentationAttributes>();

    public OTelInstrumentation(InstrumentationOptions applicationOptions, SdkInstrumentationOptions sdkOptions, String host, int port) {
        Object explicitOTel;
        Object object = explicitOTel = applicationOptions == null ? null : applicationOptions.getTelemetryProvider();
        if (explicitOTel != null && !OTelInitializer.OTEL_CLASS.isInstance(explicitOTel)) {
            throw LOGGER.atError().addKeyValue("expectedProvider", OTelInitializer.OTEL_CLASS.getName()).addKeyValue("actualProvider", explicitOTel.getClass().getName()).log("Unexpected telemetry provider type.", new IllegalArgumentException("Telemetry provider is not an instance of " + OTelInitializer.OTEL_CLASS.getName()));
        }
        Object otelInstance = explicitOTel != null ? explicitOTel : GET_GLOBAL_OTEL_INVOKER.invoke();
        this.isTracingEnabled = applicationOptions == null || applicationOptions.isTracingEnabled();
        this.isMetricsEnabled = applicationOptions == null || applicationOptions.isMetricsEnabled();
        this.allowNestedSpans = sdkOptions != null && SdkInstrumentationOptionsAccessHelper.isSpanSuppressionDisabled(sdkOptions);
        this.tracer = OTelInstrumentation.createTracer(this.isTracingEnabled, sdkOptions, otelInstance);
        this.meter = OTelInstrumentation.createMeter(this.isMetricsEnabled, sdkOptions, otelInstance);
        this.callDurationMetric = InstrumentationUtils.createOperationDurationHistogram(sdkOptions == null ? null : sdkOptions.getSdkName(), this.meter);
        this.host = host;
        this.port = port;
    }

    @Override
    public Tracer getTracer() {
        return this.tracer;
    }

    @Override
    public Meter getMeter() {
        return this.meter;
    }

    private static Tracer createTracer(boolean isTracingEnabled, SdkInstrumentationOptions sdkOptions, Object otelInstance) {
        Object otelTracerProvider;
        if (isTracingEnabled && OTelInitializer.isInitialized() && (otelTracerProvider = GET_TRACER_PROVIDER_INVOKER.invoke(otelInstance)) != null && otelTracerProvider != NOOP_PROVIDER) {
            return new OTelTracer(otelTracerProvider, sdkOptions);
        }
        return OTelTracer.NOOP;
    }

    private static Meter createMeter(boolean isMetricsEnabled, SdkInstrumentationOptions sdkOptions, Object otelInstance) {
        Object otelMeterProvider;
        if (isMetricsEnabled && OTelInitializer.isInitialized() && (otelMeterProvider = GET_METER_PROVIDER_INVOKER.invoke(otelInstance)) != null && otelMeterProvider != NOOP_PROVIDER) {
            return new OTelMeter(otelMeterProvider, sdkOptions);
        }
        return NoopMeter.INSTANCE;
    }

    @Override
    public InstrumentationAttributes createAttributes(Map<String, Object> attributes) {
        return OTelInitializer.isInitialized() ? OTelAttributes.create(attributes) : NoopAttributes.INSTANCE;
    }

    @Override
    public TraceContextPropagator getW3CTraceContextPropagator() {
        return OTelInitializer.isInitialized() ? W3C_PROPAGATOR_INSTANCE : OTelTraceContextPropagator.NOOP;
    }

    @Override
    public <T> InstrumentationContext createInstrumentationContext(T context) {
        if (context instanceof InstrumentationContext) {
            return (InstrumentationContext)context;
        }
        if (context instanceof OTelSpan) {
            return ((OTelSpan)context).getInstrumentationContext();
        }
        if (OTelInitializer.SPAN_CLASS.isInstance(context)) {
            return OTelSpanContext.fromOTelSpan(context);
        }
        if (OTelInitializer.CONTEXT_CLASS.isInstance(context)) {
            return OTelSpanContext.fromOTelContext(context);
        }
        if (OTelInitializer.SPAN_CONTEXT_CLASS.isInstance(context)) {
            return new OTelSpanContext(context, null);
        }
        return OTelSpanContext.getInvalid();
    }

    @Override
    public <TResponse> TResponse instrumentWithResponse(String operationName, RequestContext requestContext, Function<RequestContext, TResponse> operation) {
        TResponse TResponse;
        Objects.requireNonNull(operationName, "'operationName' cannot be null");
        Objects.requireNonNull(operation, "'operation' cannot be null");
        requestContext = requestContext == null ? RequestContext.none() : requestContext;
        InstrumentationContext context = requestContext.getInstrumentationContext();
        if (!this.shouldInstrument(SpanKind.CLIENT, context)) {
            return operation.apply(requestContext);
        }
        long startTimeNs = this.callDurationMetric.isEnabled() ? System.nanoTime() : 0L;
        InstrumentationAttributes commonAttributes = this.getOrCreateCommonAttributes(operationName);
        Span span = this.tracer.spanBuilder(operationName, SpanKind.CLIENT, context).setAllAttributes(commonAttributes).startSpan();
        TracingScope scope = span.makeCurrent();
        RuntimeException error = null;
        RequestContext childContext = requestContext.toBuilder().setInstrumentationContext(span.getInstrumentationContext()).build();
        try {
            TResponse = operation.apply(childContext);
        }
        catch (RuntimeException t) {
            try {
                error = t;
                throw t;
            }
            catch (Throwable throwable) {
                if (this.callDurationMetric.isEnabled()) {
                    InstrumentationAttributes attributes = error == null ? commonAttributes : commonAttributes.put("error.type", error.getClass().getCanonicalName());
                    this.callDurationMetric.record((double)(System.nanoTime() - startTimeNs) / 1.0E9, attributes, childContext.getInstrumentationContext());
                }
                span.end(error);
                scope.close();
                throw throwable;
            }
        }
        if (this.callDurationMetric.isEnabled()) {
            InstrumentationAttributes attributes = error == null ? commonAttributes : commonAttributes.put("error.type", error.getClass().getCanonicalName());
            this.callDurationMetric.record((double)(System.nanoTime() - startTimeNs) / 1.0E9, attributes, childContext.getInstrumentationContext());
        }
        span.end(error);
        scope.close();
        return TResponse;
    }

    private InstrumentationAttributes getOrCreateCommonAttributes(String operationName) {
        return this.commonAttributesCache.computeIfAbsent(operationName, name -> {
            HashMap<String, Object> attributeMap = new HashMap<String, Object>(4);
            attributeMap.put("operation.name", operationName);
            if (this.host != null) {
                attributeMap.put("server.address", this.host);
                if (this.port > 0) {
                    attributeMap.put("server.port", this.port);
                }
            }
            return this.createAttributes(attributeMap);
        });
    }

    private boolean shouldInstrument(SpanKind spanKind, InstrumentationContext context) {
        if (!this.isTracingEnabled && !this.isMetricsEnabled) {
            return false;
        }
        if (this.allowNestedSpans) {
            return true;
        }
        return spanKind != OTelInstrumentation.tryGetSpanKind(context);
    }

    private static SpanKind tryGetSpanKind(InstrumentationContext context) {
        Span span;
        if (context instanceof OTelSpanContext && (span = context.getSpan()) instanceof OTelSpan) {
            return ((OTelSpan)span).getSpanKind();
        }
        return null;
    }

    static {
        LOGGER = new ClientLogger(OTelInstrumentation.class);
        ReflectiveInvoker getTracerProviderInvoker = null;
        ReflectiveInvoker getMeterProviderInvoker = null;
        ReflectiveInvoker getGlobalOtelInvoker = null;
        Object noopProvider = null;
        Object w3cPropagatorInstance = null;
        if (OTelInitializer.isInitialized()) {
            try {
                getTracerProviderInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.OTEL_CLASS, OTelInitializer.OTEL_CLASS.getMethod("getTracerProvider", new Class[0]));
                getMeterProviderInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.OTEL_CLASS, OTelInitializer.OTEL_CLASS.getMethod("getMeterProvider", new Class[0]));
                getGlobalOtelInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.GLOBAL_OTEL_CLASS, OTelInitializer.GLOBAL_OTEL_CLASS.getMethod("get", new Class[0]));
                ReflectiveInvoker noopProviderInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.TRACER_PROVIDER_CLASS, OTelInitializer.TRACER_PROVIDER_CLASS.getMethod("noop", new Class[0]));
                noopProvider = noopProviderInvoker.invoke();
                ReflectiveInvoker w3cPropagatorInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.W3C_PROPAGATOR_CLASS, OTelInitializer.W3C_PROPAGATOR_CLASS.getMethod("getInstance", new Class[0]));
                w3cPropagatorInstance = w3cPropagatorInvoker.invoke();
            }
            catch (Throwable t) {
                OTelInitializer.initError(LOGGER, t);
            }
        }
        GET_TRACER_PROVIDER_INVOKER = new FallbackInvoker(getTracerProviderInvoker, LOGGER);
        GET_METER_PROVIDER_INVOKER = new FallbackInvoker(getMeterProviderInvoker, LOGGER);
        GET_GLOBAL_OTEL_INVOKER = new FallbackInvoker(getGlobalOtelInvoker, LOGGER);
        NOOP_PROVIDER = noopProvider;
        W3C_PROPAGATOR_INSTANCE = new OTelTraceContextPropagator(w3cPropagatorInstance);
        DEFAULT_INSTANCE = new OTelInstrumentation(null, InstrumentationUtils.UNKNOWN_LIBRARY_OPTIONS, null, -1);
    }
}

