/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public final class GenericParameterizedType
implements ParameterizedType {
    private static final ClientLogger LOGGER = new ClientLogger(GenericParameterizedType.class);
    private final Class<?> raw;
    private final Type[] args;
    private String cachedToString;

    public GenericParameterizedType(Class<?> raw, Type ... args) {
        this.raw = raw;
        if (args == null) {
            throw LOGGER.logThrowableAsError(new IllegalArgumentException("args cannot be null"));
        }
        Type[] argsCopy = new Type[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                throw LOGGER.logThrowableAsError(new IllegalArgumentException("args cannot contain null: null value in index " + i));
            }
            argsCopy[i] = args[i];
        }
        this.args = argsCopy;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.args;
    }

    @Override
    public Type getRawType() {
        return this.raw;
    }

    @Override
    public Type getOwnerType() {
        return null;
    }

    public String toString() {
        if (this.cachedToString == null) {
            this.cachedToString = this.raw.getTypeName() + "<" + Arrays.stream(this.args).map(Type::getTypeName).collect(Collectors.joining(", ")) + ">";
        }
        return this.cachedToString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericParameterizedType that = (GenericParameterizedType)o;
        return Objects.equals(this.raw, that.raw) && Objects.deepEquals(this.args, that.args);
    }

    public int hashCode() {
        return Objects.hash(this.raw, Arrays.hashCode(this.args));
    }
}

