/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.pipeline;

import io.clientcore.core.http.models.Response;
import io.clientcore.core.http.pipeline.HttpPipelinePolicy;
import io.clientcore.core.implementation.http.HttpPipelineCallState;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.binarydata.BinaryData;
import java.io.IOException;
import java.io.UncheckedIOException;

public class HttpPipelineNextPolicy {
    private static final ClientLogger LOGGER = new ClientLogger(HttpPipelineNextPolicy.class);
    private final HttpPipelineCallState state;

    HttpPipelineNextPolicy(HttpPipelineCallState state) {
        this.state = state;
    }

    public Response<BinaryData> process() {
        HttpPipelinePolicy nextPolicy = this.state.getNextPolicy();
        if (nextPolicy == null) {
            try {
                return this.state.getPipeline().getHttpClient().send(this.state.getHttpRequest());
            }
            catch (IOException e) {
                throw LOGGER.logThrowableAsError(new UncheckedIOException(e));
            }
        }
        return nextPolicy.process(this.state.getHttpRequest(), this);
    }

    public HttpPipelineNextPolicy copy() {
        return new HttpPipelineNextPolicy(this.state.copy());
    }
}

