/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.http.client;

import io.clientcore.core.http.client.HttpClient;
import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpHeaders;
import io.clientcore.core.http.models.HttpMethod;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.http.models.ServerSentEventListener;
import io.clientcore.core.implementation.http.client.InputStreamTimeoutResponseSubscriber;
import io.clientcore.core.implementation.http.client.JdkHttpRequest;
import io.clientcore.core.implementation.http.client.JdkHttpUtils;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.ServerSentResult;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.utils.ServerSentEventUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JdkHttpClient
implements HttpClient {
    private static final ClientLogger LOGGER = new ClientLogger(JdkHttpClient.class);
    private static final String NO_LISTENER_ERROR_MESSAGE = "No ServerSentEventListener attached to HttpRequest to handle the text/event-stream response";
    private final Set<String> restrictedHeaders;
    private final Duration writeTimeout;
    private final Duration responseTimeout;
    private final Duration readTimeout;
    private final boolean hasReadTimeout;
    final java.net.http.HttpClient jdkHttpClient;

    public JdkHttpClient(java.net.http.HttpClient httpClient, Set<String> restrictedHeaders, Duration writeTimeout, Duration responseTimeout, Duration readTimeout) {
        this.jdkHttpClient = httpClient;
        this.restrictedHeaders = restrictedHeaders;
        LOGGER.atVerbose().addKeyValue("headers", restrictedHeaders).log("Effective restricted headers.");
        this.writeTimeout = writeTimeout != null && !writeTimeout.isNegative() && !writeTimeout.isZero() ? writeTimeout : null;
        this.responseTimeout = responseTimeout != null && !responseTimeout.isNegative() && !responseTimeout.isZero() ? responseTimeout : null;
        this.readTimeout = readTimeout;
        this.hasReadTimeout = readTimeout != null && !readTimeout.isNegative() && !readTimeout.isZero();
    }

    @Override
    public Response<BinaryData> send(HttpRequest request) throws IOException {
        java.net.http.HttpRequest jdkRequest = this.toJdkHttpRequest(request);
        try {
            HttpResponse.BodyHandler bodyHandler = JdkHttpClient.getResponseHandler(this.hasReadTimeout, this.readTimeout, HttpResponse.BodyHandlers::ofInputStream, InputStreamTimeoutResponseSubscriber::new);
            HttpResponse<InputStream> jdKResponse = this.jdkHttpClient.send(jdkRequest, bodyHandler);
            return this.toResponse(request, jdKResponse);
        }
        catch (InterruptedException e) {
            throw LOGGER.logThrowableAsError(new RuntimeException(e));
        }
    }

    private java.net.http.HttpRequest toJdkHttpRequest(HttpRequest request) {
        return new JdkHttpRequest(request, this.restrictedHeaders, LOGGER, this.writeTimeout, this.responseTimeout);
    }

    private static <T> HttpResponse.BodyHandler<T> getResponseHandler(boolean hasReadTimeout, Duration readTimeout, Supplier<HttpResponse.BodyHandler<T>> jdkBodyHandler, Function<Long, HttpResponse.BodySubscriber<T>> timeoutSubscriber) {
        return hasReadTimeout ? responseInfo -> (HttpResponse.BodySubscriber)timeoutSubscriber.apply(readTimeout.toMillis()) : jdkBodyHandler.get();
    }

    private Response<BinaryData> toResponse(HttpRequest request, HttpResponse<InputStream> response) throws IOException {
        HttpHeaders coreHeaders = JdkHttpUtils.fromJdkHttpHeaders(response.headers());
        ServerSentResult serverSentResult = null;
        String contentType = coreHeaders.getValue(HttpHeaderName.CONTENT_TYPE);
        if (ServerSentEventUtils.isTextEventStreamContentType(contentType)) {
            ServerSentEventListener listener = request.getServerSentEventListener();
            if (listener != null) {
                serverSentResult = ServerSentEventUtils.processTextEventStream(response.body(), listener);
                if (serverSentResult.getException() != null) {
                    listener.onError(serverSentResult.getException());
                }
                if (!Thread.currentThread().isInterrupted() && ServerSentEventUtils.attemptRetry(serverSentResult, request)) {
                    return this.send(request);
                }
            } else {
                throw LOGGER.logThrowableAsError(new RuntimeException(NO_LISTENER_ERROR_MESSAGE));
            }
        }
        return this.processResponse(request, response, serverSentResult, coreHeaders, contentType);
    }

    private Response<BinaryData> processResponse(HttpRequest request, HttpResponse<InputStream> response, ServerSentResult serverSentResult, HttpHeaders coreHeaders, String contentType) throws IOException {
        BinaryData body = null;
        BodyHandling bodyHandling = this.getBodyHandling(request, coreHeaders);
        switch (bodyHandling.ordinal()) {
            case 0: {
                response.body().close();
                break;
            }
            case 1: {
                if (ServerSentEventUtils.isTextEventStreamContentType(contentType)) {
                    body = this.createBodyFromServerSentResult(serverSentResult);
                    break;
                }
                body = BinaryData.fromStream(response.body());
                break;
            }
            case 2: {
                if (ServerSentEventUtils.isTextEventStreamContentType(contentType)) {
                    body = this.createBodyFromServerSentResult(serverSentResult);
                    break;
                }
                body = this.createBodyFromResponse(response);
                break;
            }
            default: {
                body = this.createBodyFromResponse(response);
            }
        }
        return new Response<BinaryData>(request, response.statusCode(), coreHeaders, body == null ? BinaryData.empty() : body);
    }

    private BodyHandling getBodyHandling(HttpRequest request, HttpHeaders responseHeaders) {
        String contentType = responseHeaders.getValue(HttpHeaderName.CONTENT_TYPE);
        if (request.getHttpMethod() == HttpMethod.HEAD) {
            return BodyHandling.IGNORE;
        }
        if ("application/octet-stream".equalsIgnoreCase(contentType)) {
            return BodyHandling.STREAM;
        }
        return BodyHandling.BUFFER;
    }

    private BinaryData createBodyFromServerSentResult(ServerSentResult serverSentResult) {
        String bodyContent = serverSentResult != null && serverSentResult.getData() != null ? String.join((CharSequence)"\n", serverSentResult.getData()) : "";
        return BinaryData.fromString(bodyContent);
    }

    private BinaryData createBodyFromResponse(HttpResponse<InputStream> response) throws IOException {
        try (InputStream responseBody = response.body();){
            BinaryData binaryData = BinaryData.fromBytes(responseBody.readAllBytes());
            return binaryData;
        }
    }

    private static enum BodyHandling {
        IGNORE,
        STREAM,
        BUFFER;

    }
}

