/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils;

import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.utils.AuthenticateChallenge;
import io.clientcore.core.utils.ChallengeHandler;
import io.clientcore.core.utils.DigestChallengeHandler;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class CompositeChallengeHandler
implements ChallengeHandler {
    private static final ClientLogger LOGGER = new ClientLogger(CompositeChallengeHandler.class);
    private final List<ChallengeHandler> challengeHandlers;

    CompositeChallengeHandler(List<ChallengeHandler> challengeHandlers) {
        this.challengeHandlers = challengeHandlers;
    }

    @Override
    public boolean canHandle(Response<BinaryData> response, boolean isProxy) {
        for (ChallengeHandler handler : this.challengeHandlers) {
            if (!handler.canHandle(response, isProxy)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleChallenge(HttpRequest request, Response<BinaryData> response, boolean isProxy) {
        for (ChallengeHandler handler : this.challengeHandlers) {
            if (!handler.canHandle(response, isProxy) || !(handler instanceof DigestChallengeHandler)) continue;
            handler.handleChallenge(request, response, isProxy);
            return;
        }
        for (ChallengeHandler handler : this.challengeHandlers) {
            if (!handler.canHandle(response, isProxy)) continue;
            handler.handleChallenge(request, response, isProxy);
            return;
        }
        LOGGER.atError().log("None of the challenge handlers could handle the challenge.");
    }

    @Override
    public Map.Entry<String, AuthenticateChallenge> handleChallenge(String method, URI uri, List<AuthenticateChallenge> challenges) {
        Objects.requireNonNull(challenges, "Cannot use a null 'challenges' to handle challenges.");
        for (ChallengeHandler handler : this.challengeHandlers) {
            Map.Entry<String, AuthenticateChallenge> result = handler.handleChallenge(method, uri, challenges);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean canHandle(List<AuthenticateChallenge> challenges) {
        Objects.requireNonNull(challenges, "Cannot use a null 'challenges' to determine if it can be handled.");
        for (ChallengeHandler handler : this.challengeHandlers) {
            if (!handler.canHandle(challenges)) continue;
            return true;
        }
        return false;
    }
}

